import json

# Liste des couleurs avec leur nom et code hex
colors = {
    "white": ("#FFFFFF", 1),
    "light_gray": ("#999999", 2),
    "gray": ("#4C4C4C", 3),
    "black": ("#191919", 4),
    "brown": ("#664C33", 5),
    "red": ("#993333", 6),
    "orange": ("#D87F33", 7),
    "yellow": ("#E5E533", 8),
    "lime": ("#7FCC19", 9),
    "green": ("#667F33", 10),
    "cyan": ("#4C7F99", 11),
    "light_blue": ("#6699D8", 12),
    "blue": ("#334CB2", 13),
    "purple": ("#7F3FB2", 14),
    "magenta": ("#B24CD8", 15),
    "pink": ("#F27FA5", 16)
}


# Création des fichiers JSON pour chaque couleur
for color_name, (hex_code, color_value) in colors.items():
    # Nom du fichier basé sur le nom de la couleur
    file_name = f"{color_name}_item_frame.json"
    
    custom_model_data = 970000 + color_value
    
    # Contenu du fichier JSON
    data = {
        "type": "minecraft:crafting_shapeless",
        "category": "misc",
        "group": "dye_item_frame",
        "ingredients": [
            {"item": "minecraft:item_frame"},
            {"item": f"minecraft:{color_name}_dye"}
        ],
        "result": {
            "id": "minecraft:item_frame",
            "components": {
                "minecraft:item_name": "[{translate:'item.dyed'},{text:' '},{translate:'item.minecraft.item_frame'}]",
                "minecraft:rarity": "uncommon",
                "minecraft:custom_model_data": custom_model_data,
                "minecraft:lore": [
                    f"[{{text:'Color: {color_name.capitalize()}',italic:false,color:'{hex_code}'}}]"
                ],
                "minecraft:entity_data": {
                    "id": "minecraft:item_frame",
                    "Tags": [
                        "ifc_frame",
                        f"ifc_{color_name}",
                        "ifc_item_frame"
                    ]
                }
            }
        }
    }
    
    # Écriture du fichier JSON
    with open(file_name, 'w') as json_file:
        json.dump(data, json_file, indent=4)

"Les fichiers JSON ont été créés pour chaque couleur."
