/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.client.OwoClient;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.List;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8002;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.w3c.dom.Element;

public interface Surface {
    public static final Surface PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), false);
    public static final Surface DARK_PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), true);
    public static final Surface PANEL_INSET = (context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component);
    public static final Surface VANILLA_TRANSLUCENT = (context, component) -> context.drawGradientRect(component.x(), component.y(), component.width(), component.height(), -1072689136, -1072689136, -804253680, -804253680);
    public static final Surface OPTIONS_BACKGROUND = (context, component) -> {
        class_310.method_1551().field_1773.method_57796(0.0f);
        class_310.method_1551().method_1522().method_1235(false);
    };
    public static final Surface TOOLTIP = (context, component) -> context.method_51741(() -> {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_8002.method_47946((class_332)context, (int)(component.x() + 4), (int)(component.y() + 4), (int)(component.width() - 8), (int)(component.height() - 8), (int)0);
    });
    public static final Surface BLANK = (context, component) -> {};

    public static Surface blur(float quality, float size) {
        return (context, component) -> {
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            buffer.method_22918(matrix, (float)component.x(), (float)component.y(), 0.0f);
            buffer.method_22918(matrix, (float)component.x(), (float)(component.y() + component.height()), 0.0f);
            buffer.method_22918(matrix, (float)(component.x() + component.width()), (float)(component.y() + component.height()), 0.0f);
            buffer.method_22918(matrix, (float)(component.x() + component.width()), (float)component.y(), 0.0f);
            OwoClient.BLUR_PROGRAM.setParameters(16, quality, size);
            OwoClient.BLUR_PROGRAM.use();
            class_286.method_43433((class_9801)buffer.method_60800());
        };
    }

    public static Surface flat(int color) {
        return (context, component) -> context.method_25294(component.x(), component.y(), component.x() + component.width(), component.y() + component.height(), color);
    }

    public static Surface outline(int color) {
        return (context, component) -> context.drawRectOutline(component.x(), component.y(), component.width(), component.height(), color);
    }

    public static Surface tiled(class_2960 texture, int textureWidth, int textureHeight) {
        return (context, component) -> context.method_25290(texture, component.x(), component.y(), 0.0f, 0.0f, component.width(), component.height(), textureWidth, textureHeight);
    }

    public static Surface panelWithInset(int insetWidth) {
        return PANEL.and((context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component.x() + insetWidth, component.y() + insetWidth, component.width() - insetWidth * 2, component.height() - insetWidth * 2));
    }

    public void draw(OwoUIDrawContext var1, ParentComponent var2);

    default public Surface and(Surface surface) {
        return (context, component) -> {
            this.draw(context, component);
            surface.draw(context, component);
        };
    }

    public static Surface parse(Element surfaceElement) {
        List<Element> children = UIParsing.allChildrenOfType(surfaceElement, (short)1);
        Surface surface = BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? DARK_PANEL : PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes(child, "texture-width", "texture-height");
                    yield surface.and(Surface.tiled(UIParsing.parseIdentifier(child), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-height"))));
                }
                case "blur" -> {
                    UIParsing.expectAttributes(child, "size", "quality");
                    yield surface.and(Surface.blur(UIParsing.parseFloat(child.getAttributeNode("quality")), UIParsing.parseFloat(child.getAttributeNode("size"))));
                }
                case "panel-with-inset" -> surface.and(Surface.panelWithInset(UIParsing.parseUnsignedInt(child)));
                case "options-background" -> surface.and(OPTIONS_BACKGROUND);
                case "vanilla-translucent" -> surface.and(VANILLA_TRANSLUCENT);
                case "panel-inset" -> surface.and(PANEL_INSET);
                case "tooltip" -> surface.and(TOOLTIP);
                case "outline" -> surface.and(Surface.outline(Color.parseAndPack(child)));
                case "flat" -> surface.and(Surface.flat(Color.parseAndPack(child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
        }
        return surface;
    }
}

