/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmEndec;
import io.wispforest.endec.format.edm.EdmSerializer;
import io.wispforest.endec.format.edm.LenientEdmDeserializer;
import io.wispforest.owo.mixin.ForwardingDynamicOpsAccessor;
import io.wispforest.owo.mixin.RegistryOpsAccessor;
import io.wispforest.owo.serialization.RegistriesAttribute;
import io.wispforest.owo.serialization.endec.EitherEndec;
import io.wispforest.owo.serialization.format.edm.EdmOps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_5379;
import net.minecraft.class_6903;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class CodecUtils {
    public static <T> Endec<T> toEndec(Codec<T> codec) {
        return Endec.of((ctx, serializer, value) -> {
            EdmOps ops = EdmOps.withContext(ctx);
            if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
                ops = class_6903.method_40414((DynamicOps)ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
            }
            EdmEndec.INSTANCE.encode(ctx, serializer, (EdmElement)codec.encodeStart((DynamicOps)ops, value).getOrThrow(IllegalStateException::new));
        }, (ctx, deserializer) -> {
            EdmOps ops = EdmOps.withContext(ctx);
            if (ctx.hasAttribute(RegistriesAttribute.REGISTRIES)) {
                ops = class_6903.method_40414((DynamicOps)ops, (class_6903.class_7863)((RegistriesAttribute)ctx.getAttributeValue(RegistriesAttribute.REGISTRIES)).infoGetter());
            }
            return codec.parse((DynamicOps)ops, (Object)EdmEndec.INSTANCE.decode(ctx, deserializer)).getOrThrow(IllegalStateException::new);
        });
    }

    public static <F, S> Endec<Either<F, S>> eitherEndec(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, false);
    }

    public static <F, S> Endec<Either<F, S>> xorEndec(Endec<F> first, Endec<S> second) {
        return new EitherEndec<F, S>(first, second, true);
    }

    public static <T> Codec<T> toCodec(final Endec<T> endec, final SerializationContext assumedContext) {
        return new Codec<T>(){

            public <D> DataResult<Pair<T, D>> decode(DynamicOps<D> ops, D input) {
                try {
                    SerializationContext context;
                    Object rootOps = ops;
                    while (rootOps instanceof class_5379) {
                        rootOps = ((ForwardingDynamicOpsAccessor)rootOps).owo$delegate();
                    }
                    if (rootOps instanceof EdmOps) {
                        EdmOps edmOps = (EdmOps)rootOps;
                        v0 = edmOps.capturedContext().and(assumedContext);
                    } else {
                        v0 = context = assumedContext;
                    }
                    if (ops instanceof class_6903) {
                        class_6903 registryOps = (class_6903)ops;
                        context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.infoGetterOnly(((RegistryOpsAccessor)registryOps).owo$infoGetter())});
                    }
                    return DataResult.success((Object)new Pair(endec.decode(context, (Deserializer)LenientEdmDeserializer.of((EdmElement)((EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), input)))), input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <D> DataResult<D> encode(T input, DynamicOps<D> ops, D prefix) {
                try {
                    SerializationContext context;
                    Object rootOps = ops;
                    while (rootOps instanceof class_5379) {
                        rootOps = ((ForwardingDynamicOpsAccessor)rootOps).owo$delegate();
                    }
                    if (rootOps instanceof EdmOps) {
                        EdmOps edmOps = (EdmOps)rootOps;
                        v0 = edmOps.capturedContext().and(assumedContext);
                    } else {
                        v0 = context = assumedContext;
                    }
                    if (ops instanceof class_6903) {
                        class_6903 registryOps = (class_6903)ops;
                        context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.infoGetterOnly(((RegistryOpsAccessor)registryOps).owo$infoGetter())});
                    }
                    return DataResult.success(EdmOps.withoutContext().convertTo(ops, (EdmElement)endec.encodeFully(context, EdmSerializer::of, input)));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        };
    }

    public static <T> Codec<T> toCodec(Endec<T> endec) {
        return CodecUtils.toCodec(endec, SerializationContext.empty());
    }

    public static <T> MapCodec<T> toMapCodec(final StructEndec<T> structEndec, final SerializationContext assumedContext) {
        return new MapCodec<T>(){

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                throw new UnsupportedOperationException("MapCodec generated from StructEndec cannot report keys");
            }

            public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                try {
                    SerializationContext context;
                    HashMap map = new HashMap();
                    input.entries().forEach(pair -> map.put((String)ops.getStringValue(pair.getFirst()).getOrThrow(s -> new IllegalStateException("Unable to parse key: " + s)), (EdmElement)ops.convertTo((DynamicOps)EdmOps.withoutContext(), pair.getSecond())));
                    Object rootOps = ops;
                    while (rootOps instanceof class_5379) {
                        rootOps = ((ForwardingDynamicOpsAccessor)ops).owo$delegate();
                    }
                    if (rootOps instanceof EdmOps) {
                        EdmOps edmOps = (EdmOps)rootOps;
                        v0 = edmOps.capturedContext().and(assumedContext);
                    } else {
                        v0 = context = assumedContext;
                    }
                    if (ops instanceof class_6903) {
                        class_6903 registryOps = (class_6903)ops;
                        context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.infoGetterOnly(((RegistryOpsAccessor)registryOps).owo$infoGetter())});
                    }
                    return DataResult.success((Object)structEndec.decode(context, (Deserializer)LenientEdmDeserializer.of((EdmElement)EdmElement.wrapMap(map))));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                try {
                    SerializationContext context;
                    Object rootOps = ops;
                    while (rootOps instanceof class_5379) {
                        rootOps = ((ForwardingDynamicOpsAccessor)ops).owo$delegate();
                    }
                    if (rootOps instanceof EdmOps) {
                        EdmOps edmOps = (EdmOps)rootOps;
                        v0 = edmOps.capturedContext().and(assumedContext);
                    } else {
                        v0 = context = assumedContext;
                    }
                    if (ops instanceof class_6903) {
                        class_6903 registryOps = (class_6903)ops;
                        context = context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.infoGetterOnly(((RegistryOpsAccessor)registryOps).owo$infoGetter())});
                    }
                    Map element = (Map)((EdmElement)structEndec.encodeFully(context, EdmSerializer::of, input)).cast();
                    RecordBuilder result = prefix;
                    for (Map.Entry entry : element.entrySet()) {
                        result = result.add((String)entry.getKey(), EdmOps.withoutContext().convertTo(ops, (EdmElement)entry.getValue()));
                    }
                    return result;
                }
                catch (Exception e) {
                    return prefix.withErrorsFrom(DataResult.error(e::getMessage, input));
                }
            }
        };
    }

    public static <T> MapCodec<T> toMapCodec(StructEndec<T> structEndec) {
        return CodecUtils.toMapCodec(structEndec, SerializationContext.empty());
    }

    public static <B extends class_2540, T> class_9139<B, T> toPacketCodec(final Endec<T> endec) {
        return new class_9139<B, T>(){

            public T decode(B buf) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                return endec.decode(ctx, (Deserializer)ByteBufDeserializer.of(buf));
            }

            public void encode(B buf, T value) {
                SerializationContext serializationContext;
                if (buf instanceof class_9129) {
                    class_9129 registryByteBuf = (class_9129)buf;
                    serializationContext = SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of(registryByteBuf.method_56349())});
                } else {
                    serializationContext = SerializationContext.empty();
                }
                SerializationContext ctx = serializationContext;
                endec.encode(ctx, (Serializer)ByteBufSerializer.of(buf), value);
            }
        };
    }
}

