/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.init;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1269;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2396;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.particle.FallingLeafParticle;
import randommcsomethin.fallingleaves.util.LeafUtil;
import randommcsomethin.fallingleaves.util.RegistryUtil;
import randommcsomethin.fallingleaves.util.TextureCache;

public class Leaves {
    public static final class_2396<class_2388> FALLING_LEAF;
    public static final class_2396<class_2388> FALLING_CONIFER_LEAF;
    public static final class_2396<class_2388> FALLING_SNOW;
    public static final Map<class_2396<class_2388>, class_2960> LEAVES;
    public static final Map<class_2396<class_2388>, class_707<class_2388>> FACTORIES;
    private static boolean preLoadedRegisteredLeafBlocks;

    public static void init() {
        if (Config.CONFIG.registerParticles) {
            FallingLeavesClient.LOGGER.info("Registering leaf particles.");
            Leaves.registerLeafParticles();
        }
        Leaves.registerReloadListener();
        Leaves.registerAttackBlockLeaves();
    }

    private static void registerLeafParticles() {
        for (Map.Entry<class_2396<class_2388>, class_2960> entry : LEAVES.entrySet()) {
            class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)entry.getValue(), entry.getKey());
            ParticleFactoryRegistry.getInstance().register(entry.getKey(), FallingLeafParticle.BlockStateFactory::new);
        }
    }

    private static void registerReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 resourceManager) {
                if (!preLoadedRegisteredLeafBlocks) {
                    for (Map.Entry<class_2960, LeafSettingsEntry> registered : LeafUtil.getRegisteredLeafBlocks(false).entrySet()) {
                        Config.CONFIG.leafSettings.computeIfAbsent(registered.getKey(), k -> (LeafSettingsEntry)registered.getValue());
                    }
                    preLoadedRegisteredLeafBlocks = true;
                }
                TextureCache.INST.clear();
            }

            public class_2960 getFabricId() {
                return RegistryUtil.makeId("resource_reload_listener");
            }
        });
    }

    private static void registerAttackBlockLeaves() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!(Config.CONFIG.enabled && Config.CONFIG.leavesOnBlockHit && world.field_9236)) {
                return class_1269.field_5811;
            }
            class_2680 state = world.method_8320(pos);
            LeafSettingsEntry leafSettings = LeafUtil.getLeafSettingsEntry(state);
            if (leafSettings != null) {
                int i;
                if (leafSettings.spawnBreakingLeaves) {
                    int count = 0;
                    for (i = 0; i < 3; ++i) {
                        if (!world.field_9229.method_43056()) continue;
                        ++count;
                    }
                    LeafUtil.spawnLeafParticles(count, false, state, world, pos, world.field_9229, leafSettings);
                }
                if (Config.CONFIG.getSnowflakeSpawnChance() != 0.0) {
                    int snowCount = 0;
                    for (i = 0; i < 6; ++i) {
                        if (!world.field_9229.method_43056()) continue;
                        ++snowCount;
                    }
                    LeafUtil.spawnSnowParticles(snowCount, false, state, world, pos, world.field_9229, leafSettings);
                }
            }
            return class_1269.field_5811;
        });
    }

    static {
        FACTORIES = new IdentityHashMap<class_2396<class_2388>, class_707<class_2388>>();
        preLoadedRegisteredLeafBlocks = false;
        FALLING_LEAF = FabricParticleTypes.complex((boolean)true, class_2388::method_29128, class_2388::method_56170);
        FALLING_CONIFER_LEAF = FabricParticleTypes.complex((boolean)true, class_2388::method_29128, class_2388::method_56170);
        FALLING_SNOW = FabricParticleTypes.complex((boolean)true, class_2388::method_29128, class_2388::method_56170);
        LEAVES = Map.of(FALLING_LEAF, RegistryUtil.makeId("falling_leaf"), FALLING_CONIFER_LEAF, RegistryUtil.makeId("falling_leaf_conifer"), FALLING_SNOW, RegistryUtil.makeId("falling_snow"));
    }
}

