/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.SoundDefinition;
import dev.imb11.sounds.dynamic.DynamicSoundHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundsReloadListener
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundsReloadListener.class);
    private static final Gson GSON = new Gson();

    public class_2960 getFabricId() {
        return SoundsClient.id("sounds_reload_listener");
    }

    public void method_14491(class_3300 manager) {
        DynamicSoundHelper.clearDefinitions();
        DynamicSoundHelper.loadDirectories.forEach((directory, codec) -> {
            ArrayList<?> resultList = DynamicSoundHelper.loadedDefinitions.get(directory);
            for (class_2960 id : manager.method_14488("sounds/" + directory, path -> path.method_12832().endsWith(".json")).keySet()) {
                try {
                    class_3298 resource = (class_3298)manager.method_14486(id).orElseThrow();
                    InputStream inputStream = resource.method_14482();
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream));
                    SoundDefinition result = (SoundDefinition)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson(reader, JsonObject.class))).result().orElseThrow();
                    resultList.add(result);
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while loading resource json: " + id.toString(), (Throwable)e);
                }
            }
            DynamicSoundHelper.loadedDefinitions.put((String)directory, resultList);
        });
        ArrayList items = new ArrayList();
        class_7923.field_41178.method_40270().forEach(item -> items.add((class_1792)item.comp_349()));
        ArrayList itemsWithLoadedDefinitions = new ArrayList();
        DynamicSoundHelper.loadedDefinitions.get("items").forEach(definition -> {
            SoundDefinition definitionCast = (SoundDefinition)definition;
            for (Either registryKeyTagKeyEither : definitionCast.getKeys().getInternalList()) {
                if (registryKeyTagKeyEither.left().isPresent()) {
                    class_5321 key = (class_5321)registryKeyTagKeyEither.left().get();
                    class_1792 entry = (class_1792)class_7923.field_41178.method_10223(key.method_29177());
                    itemsWithLoadedDefinitions.add(entry);
                    continue;
                }
                if (!registryKeyTagKeyEither.right().isPresent()) continue;
                class_6862 tagKey = (class_6862)registryKeyTagKeyEither.right().get();
                class_6885.class_6888 entries = class_7923.field_41178.method_40260(tagKey);
                for (class_6880 key : entries) {
                    class_1792 entry = (class_1792)class_7923.field_41178.method_29107((class_5321)key.method_40230().get());
                    itemsWithLoadedDefinitions.add(entry);
                }
            }
        });
    }
}

