/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.WorldSoundsConfig;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class TagPair {
    private static final Codec<class_2498> BLOCK_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("pitch").forGetter(class_2498::method_10599), (App)Codec.FLOAT.fieldOf("volume").forGetter(class_2498::method_10597), (App)class_3414.field_41698.fieldOf("break").forGetter(class_2498::method_10595), (App)class_3414.field_41698.fieldOf("step").forGetter(class_2498::method_10594), (App)class_3414.field_41698.fieldOf("place").forGetter(class_2498::method_10598), (App)class_3414.field_41698.fieldOf("hit").forGetter(class_2498::method_10596), (App)class_3414.field_41698.fieldOf("fall").forGetter(class_2498::method_10593)).apply((Applicative)instance, class_2498::new));
    public static final Codec<TagPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("blockTag").forGetter(TagPair::getBlockTagID), (App)BLOCK_GROUP_CODEC.fieldOf("group").forGetter(TagPair::getGroup), (App)Codec.BOOL.fieldOf("enabled").forGetter(TagPair::isEnabled)).apply((Applicative)instance, TagPair::new));
    private final class_6862<class_2248> blockTag;
    private class_2498 group;
    private class_2498 pendingGroup;
    private boolean enabled;

    @ApiStatus.Internal
    public static void handleTagPair(class_2680 state, CallbackInfoReturnable<class_2498> cir) {
        TagPair pair;
        class_6880 entry = state.method_41520();
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        Stream tagPairStream = SoundsConfig.get(WorldSoundsConfig.class).getAllTagPairs().stream();
        ((Stream)tagPairStream.parallel()).forEach(allTagPair -> {
            if (result.get() != null) {
                return;
            }
            if (ClientTags.isInWithLocalFallback(((TagPair)allTagPair.get()).getBlockTag(), (class_6880)entry)) {
                result.set(allTagPair);
            }
        });
        if (result.get() != null && (pair = (TagPair)((Supplier)result.get()).get()).isEnabled()) {
            cir.setReturnValue((Object)pair.getGroup());
        }
    }

    public class_2960 getBlockTagID() {
        return this.blockTag.comp_327();
    }

    public class_6862<class_2248> getBlockTag() {
        return this.blockTag;
    }

    public class_2498 getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TagPair(class_6862<class_2248> blockTag, class_2498 group) {
        this.blockTag = blockTag;
        this.group = group;
        this.pendingGroup = group;
        this.enabled = true;
    }

    public TagPair(class_2960 blockTag, class_2498 group, boolean enabled) {
        this((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)blockTag), group);
        this.enabled = enabled;
    }

    private void playSound(class_3414 event) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)event, (float)this.group.method_10599(), (float)this.group.method_10597()));
    }

    public ButtonOption createAction(String type) {
        Consumer<Void> action = e -> {
            switch (type) {
                case "break": {
                    this.playSound(this.group.method_10595());
                    break;
                }
                case "step": {
                    this.playSound(this.group.method_10594());
                    break;
                }
                case "place": {
                    this.playSound(this.group.method_10598());
                    break;
                }
                case "hit": {
                    this.playSound(this.group.method_10596());
                    break;
                }
                case "fall": {
                    this.playSound(this.group.method_10593());
                }
            }
        };
        return ButtonOption.createBuilder().name((class_2561)class_2561.method_43469((String)"sounds.config.preview.name.brackets", (Object[])new Object[]{class_2561.method_43471((String)("sounds.config.preview." + type)).getString()})).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sounds.config.preview.description")})).action((a, b) -> action.accept(null)).build();
    }

    public Option<String> createSoundOpt(TagPair defaults, String type) {
        Option.Builder builder = Option.createBuilder().name((class_2561)class_2561.method_43469((String)"sounds.config.event.name.brackets", (Object[])new Object[]{class_2561.method_43471((String)("sounds.config.preview." + type)).getString()})).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.event.description")}).build());
        return builder.binding((Object)(switch (type) {
            case "break" -> defaults.group.method_10595().method_14833().toString();
            case "step" -> defaults.group.method_10594().method_14833().toString();
            case "place" -> defaults.group.method_10598().method_14833().toString();
            case "hit" -> defaults.group.method_10596().method_14833().toString();
            case "fall" -> defaults.group.method_10593().method_14833().toString();
            default -> "";
        }), () -> switch (type) {
            case "break" -> this.group.method_10595().method_14833().toString();
            case "step" -> this.group.method_10594().method_14833().toString();
            case "place" -> this.group.method_10598().method_14833().toString();
            case "hit" -> this.group.method_10596().method_14833().toString();
            case "fall" -> this.group.method_10593().method_14833().toString();
            default -> "";
        }, val -> {
            class_3414 event = (class_3414)class_7923.field_41172.method_10223(class_2960.method_12829((String)val));
            switch (type) {
                case "break": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), event, this.group.method_10594(), this.group.method_10598(), this.group.method_10596(), this.group.method_10593());
                    break;
                }
                case "step": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), event, this.group.method_10598(), this.group.method_10596(), this.group.method_10593());
                    break;
                }
                case "place": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), this.group.method_10594(), event, this.group.method_10596(), this.group.method_10593());
                    break;
                }
                case "hit": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), this.group.method_10594(), this.group.method_10598(), event, this.group.method_10593());
                    break;
                }
                case "fall": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), this.group.method_10594(), this.group.method_10598(), this.group.method_10596(), event);
                }
            }
        }).listener((opt, val) -> {
            class_3414 event = (class_3414)class_7923.field_41172.method_10223(class_2960.method_12829((String)val));
            switch (type) {
                case "break": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), event, this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
                    break;
                }
                case "step": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), event, this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
                    break;
                }
                case "place": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), event, this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
                    break;
                }
                case "hit": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), event, this.pendingGroup.method_10593());
                    break;
                }
                case "fall": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), event);
                }
            }
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(false).values(class_7923.field_41172.method_42021().stream().map(class_5321::method_29177).map(class_2960::toString).toList())).build();
    }

    public OptionGroup createYACL(TagPair defaults) {
        ButtonOption breakOpt = this.createAction("break");
        ButtonOption stepOpt = this.createAction("step");
        ButtonOption placeOpt = this.createAction("place");
        ButtonOption hitOpt = this.createAction("hit");
        ButtonOption fallOpt = this.createAction("fall");
        Option volumeOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.volume.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.volume.description")}).build()).binding((Object)Float.valueOf(defaults.group.method_10597()), () -> Float.valueOf(this.group.method_10597()), val -> {
            this.group = new class_2498(val.floatValue(), this.group.field_11539, this.group.method_10595(), this.group.method_10594(), this.group.method_10598(), this.group.method_10596(), this.group.method_10593());
        }).listener((opt, val) -> {
            this.pendingGroup = new class_2498(val.floatValue(), this.pendingGroup.field_11539, this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).step((Number)Float.valueOf(0.1f))).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).build();
        Option pitchOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.pitch.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.pitch.description")}).build()).binding((Object)Float.valueOf(defaults.group.method_10599()), () -> Float.valueOf(this.group.method_10599()), val -> {
            this.group = new class_2498(this.group.field_11540, val.floatValue(), this.group.method_10595(), this.group.method_10594(), this.group.method_10598(), this.group.method_10596(), this.group.method_10593());
        }).listener((opt, val) -> {
            this.pendingGroup = new class_2498(this.pendingGroup.field_11540, val.floatValue(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).step((Number)Float.valueOf(0.1f))).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).build();
        Option<String> breakSound = this.createSoundOpt(defaults, "break");
        Option<String> stepSound = this.createSoundOpt(defaults, "step");
        Option<String> placeSound = this.createSoundOpt(defaults, "place");
        Option<String> hitSound = this.createSoundOpt(defaults, "hit");
        Option<String> fallSound = this.createSoundOpt(defaults, "fall");
        Option shouldPlay = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.shouldPlay.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.shouldPlay.description")}).build()).binding((Object)defaults.enabled, () -> this.enabled, val -> {
            this.enabled = val;
        }).listener((opt, val) -> {
            breakSound.setAvailable(val.booleanValue());
            stepSound.setAvailable(val.booleanValue());
            placeSound.setAvailable(val.booleanValue());
            hitSound.setAvailable(val.booleanValue());
            pitchOpt.setAvailable(val.booleanValue());
            volumeOpt.setAvailable(val.booleanValue());
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).build();
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)this.blockTag.comp_327().toString())).collapsed(true).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sounds.config.tag.description")})).options(List.of(shouldPlay, volumeOpt, pitchOpt, breakSound, stepSound, placeSound, hitSound, fallSound, breakOpt, stepOpt, placeOpt, hitOpt, fallOpt)).build();
    }
}

