/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.mru.updates;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public class ModUpdateChecker {
    private final String modrinthID;
    private final ModContainer modContainer;

    public ModUpdateChecker(String modrinthID, ModContainer modContainer) {
        this.modrinthID = modrinthID;
        this.modContainer = modContainer;
    }

    public String getModrinthID() {
        return this.modrinthID;
    }

    public ModContainer getModContainer() {
        return this.modContainer;
    }

    public boolean doesNeedUpdating() {
        try {
            System.out.println("Checking for updates for " + this.modContainer.getMetadata().getName() + "...");
            HttpRequest request = HttpRequest.newBuilder(new URI("https://api.mineblock11.dev/v2/update/" + this.modrinthID)).GET().build();
            HttpClient client = HttpClient.newBuilder().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String json = response.body();
            System.out.println("JSON: " + json);
            Gson gson = new Gson();
            JsonObject modReleases = (JsonObject)gson.fromJson(json, JsonObject.class);
            JsonObject latest = modReleases.get("latest").getAsJsonObject();
            String versionString = latest.get("versionString").getAsString();
            int result = this.modContainer.getMetadata().getVersion().compareTo((Object)Version.parse((String)versionString));
            return result < 0;
        }
        catch (IOException | InterruptedException | URISyntaxException | VersionParsingException e) {
            e.printStackTrace();
            return false;
        }
    }
}

