/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_3545;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;

public class IfMethod
extends MathMethod {
    public IfMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = IfMethod.parseAllArgs(args, calculationInstance);
        if (parsedArgs.size() == 3) {
            MathComponent bool = parsedArgs.get(0);
            MathComponent tru = parsedArgs.get(1);
            MathComponent fals = parsedArgs.get(2);
            if (bool.isConstant()) {
                this.setOptimizedAlternativeToThis(MathValue.toBoolean(bool.getResult()) ? tru : fals);
            }
            this.setSupplierAndOptimize(() -> {
                float condition = bool.getResult();
                if (MathValue.toBoolean(condition)) {
                    return tru.getResult();
                }
                return fals.getResult();
            }, parsedArgs);
        } else {
            ArrayList<class_3545> ifSets = new ArrayList<class_3545>();
            MathComponent lastElse = parsedArgs.get(parsedArgs.size() - 1);
            Iterator<MathComponent> iterator = parsedArgs.iterator();
            while (iterator.hasNext()) {
                MathComponent next = iterator.next();
                if (!iterator.hasNext()) continue;
                if (!next.isConstant()) {
                    MathValue.toBoolean(next.getResult());
                    ifSets.add(new class_3545((Object)next, (Object)iterator.next()));
                    continue;
                }
                if (!MathValue.toBoolean(next.getResult())) continue;
                lastElse = iterator.next();
                break;
            }
            if (ifSets.isEmpty()) {
                this.setOptimizedAlternativeToThis(lastElse);
            }
            MathComponent finalElse = lastElse;
            this.setSupplierAndOptimize(() -> {
                for (class_3545 ifSet : ifSets) {
                    if (!MathValue.toBoolean(((MathComponent)ifSet.method_15442()).getResult())) continue;
                    return ((MathComponent)ifSet.method_15441()).getResult();
                }
                return finalElse.getResult();
            }, parsedArgs);
        }
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3 && argCount % 2 == 1;
    }
}

