/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5616;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;
import traben.entity_model_features.models.animation.math.variables.VariableRegistry;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.tconfig.TConfig;
import traben.tconfig.gui.TConfigScreenList;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryCustomButton;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;
import traben.tconfig.gui.entries.TConfigEntryInt;
import traben.tconfig.gui.entries.TConfigEntryText;

public class EMFConfig
extends TConfig {
    public boolean logModelCreationData = false;
    public boolean debugOnRightClick = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode_2 = VanillaModelRenderMode.OFF;
    public boolean attemptRevertingEntityModelsAlteredByAnotherMod = true;
    public ModelPrintMode modelExportMode = ModelPrintMode.NONE;
    public PhysicsModCompatChoice attemptPhysicsModPatch_2 = PhysicsModCompatChoice.CUSTOM;
    public ETFConfig.UpdateFrequency modelUpdateFrequency = ETFConfig.UpdateFrequency.Average;
    public ETFConfig.String2EnumNullMap<RenderModeChoice> entityRenderModeOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<PhysicsModCompatChoice> entityPhysicsModPatchOverrides = new ETFConfig.String2EnumNullMap();
    public ETFConfig.String2EnumNullMap<VanillaModelRenderMode> entityVanillaHologramOverrides = new ETFConfig.String2EnumNullMap();
    public ObjectOpenHashSet<String> modelsNamesDisabled = new ObjectOpenHashSet();
    public boolean allowEBEModConfigModify = true;
    public int animationLODDistance = 20;
    public boolean retainDetailOnLowFps = true;
    public boolean retainDetailOnLargerMobs = true;
    public boolean animationFrameSkipDuringIrisShadowPass = true;
    public boolean preventFirstPersonHandAnimating = false;
    public boolean onlyClientPlayerModel = false;

    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntry[]{new TConfigEntryCategory("config.entity_features.models_main").add(new TConfigEntry[]{new TConfigEntryCategory("entity_model_features.config.options", "entity_model_features.config.options.tooltip").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.force_models", "entity_model_features.config.force_models.tooltip", () -> this.attemptRevertingEntityModelsAlteredByAnotherMod, value -> {
            this.attemptRevertingEntityModelsAlteredByAnotherMod = value;
        }, true), new TConfigEntryEnumButton("entity_model_features.config.physics", "entity_model_features.config.physics.tooltip", () -> this.attemptPhysicsModPatch_2, value -> {
            this.attemptPhysicsModPatch_2 = value;
        }, (Enum)PhysicsModCompatChoice.CUSTOM), new TConfigEntryBoolean("entity_model_features.config.ebe_config_modify", "entity_model_features.config.ebe_config_modify.tooltip", () -> this.allowEBEModConfigModify, value -> {
            this.allowEBEModConfigModify = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.player_settings").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.prevent_hand", "entity_model_features.config.prevent_hand.tooltip", () -> this.preventFirstPersonHandAnimating, value -> {
            this.preventFirstPersonHandAnimating = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.only_client", "entity_model_features.config.only_client.tooltip", () -> this.onlyClientPlayerModel, value -> {
            this.onlyClientPlayerModel = value;
        }, false)}), new TConfigEntryCategory("entity_model_features.config.performance").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.update", "entity_model_features.config.update.tooltip", () -> this.modelUpdateFrequency, value -> {
            this.modelUpdateFrequency = value;
        }, (Enum)ETFConfig.UpdateFrequency.Average), new TConfigEntryInt("entity_model_features.config.lod", "entity_model_features.config.lod.tooltip", () -> this.animationLODDistance, value -> {
            this.animationLODDistance = value;
        }, 20, 0, 65, true, true), new TConfigEntryBoolean("entity_model_features.config.low_fps_lod", "entity_model_features.config.low_fps_lod.tooltip", () -> this.retainDetailOnLowFps, value -> {
            this.retainDetailOnLowFps = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.large_mob_lod", "entity_model_features.config.large_mob_lod.tooltip", () -> this.retainDetailOnLargerMobs, value -> {
            this.retainDetailOnLargerMobs = value;
        }, true), new TConfigEntryBoolean("entity_model_features.config.iris_shadow_skip", "entity_model_features.config.iris_shadow_skip.tooltip", () -> this.animationFrameSkipDuringIrisShadowPass, value -> {
            this.animationFrameSkipDuringIrisShadowPass = value;
        }, true)}), new TConfigEntryCategory("entity_model_features.config.tools", "entity_model_features.config.tools.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> this.vanillaModelHologramRenderMode_2, value -> {
            this.vanillaModelHologramRenderMode_2 = value;
        }, (Enum)VanillaModelRenderMode.OFF), new TConfigEntryEnumSlider("entity_model_features.config.print_mode", "entity_model_features.config.print_mode.tooltip", () -> this.modelExportMode, value -> {
            this.modelExportMode = value;
        }, (Enum)ModelPrintMode.NONE)}), new TConfigEntryCategory("entity_model_features.config.debug", "entity_model_features.config.debug.tooltip").add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> this.renderModeChoice, value -> {
            this.renderModeChoice = value;
        }, (Enum)RenderModeChoice.NORMAL), new TConfigEntryBoolean("entity_model_features.config.log_models", "entity_model_features.config.log_models.tooltip", () -> this.logModelCreationData, value -> {
            this.logModelCreationData = value;
        }, false), new TConfigEntryBoolean("entity_model_features.config.debug_right_click", "entity_model_features.config.debug_right_click.tooltip", () -> this.debugOnRightClick, value -> {
            this.debugOnRightClick = value;
        }, false)}), this.getModelSettings(), this.getMathInfo()}), this.getEntitySettings()});
    }

    private TConfigEntryCategory getMathInfo() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.math");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.math.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        TConfigEntryCategory variables = new TConfigEntryCategory("entity_model_features.config.variables");
        category.add((TConfigEntry)variables);
        variables.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.variables.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        for (UniqueVariableFactory uniqueVariableFactory : VariableRegistry.getInstance().getUniqueVariableFactories()) {
            TConfigEntryCategory unique = new TConfigEntryCategory(uniqueVariableFactory.getTitleTranslationKey()).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)uniqueVariableFactory.getExplanationTranslationKey(), (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        }
        VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = VariableRegistry.getInstance().getSingletonVariableExplanationTranslationKeys().get(key);
            TConfigEntryCategory unique = new TConfigEntryCategory(key).addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            variables.add((TConfigEntry)unique);
        });
        TConfigEntryCategory methods = new TConfigEntryCategory("entity_model_features.config.functions");
        category.add((TConfigEntry)methods);
        methods.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.functions.explain", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        MethodRegistry.getInstance().getMethodExplanationTranslationKeys().keySet().stream().sorted().forEach(key -> {
            String value = MethodRegistry.getInstance().getMethodExplanationTranslationKeys().get(key);
            TConfigEntryCategory method = new TConfigEntryCategory(key + "()").addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)value, (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            methods.add((TConfigEntry)method);
        });
        return category;
    }

    private TConfigEntryCategory getModelSettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("entity_model_features.config.models");
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models_text", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        EMFManager.getInstance().cache_LayersByModelName.keySet().stream().sorted().forEach(mapData -> {
            class_5607 vanilla;
            class_5601 layer = (class_5601)EMFManager.getInstance().cache_LayersByModelName.get(mapData);
            if (layer != null && (vanilla = (class_5607)class_310.method_1551().method_31974().field_27542.get(layer)) != null) {
                String namespace = "minecraft".equals(mapData.getNamespace()) ? "" : mapData.getNamespace() + ":";
                String fileName = namespace + mapData.getfileName();
                TConfigEntryCategory model = new TConfigEntryCategory(fileName + ".jem");
                model.setAlign(TConfigScreenList.Align.RIGHT);
                model.setWidgetBackgroundToFullWidth();
                model.setRenderFeature((TConfigScreenList.Renderable)new ModelRootRenderer(layer));
                category.add((TConfigEntry)model);
                model.add(new TConfigEntry[]{new TConfigEntryBoolean("entity_model_features.config.models.enabled", "entity_model_features.config.models.enabled.tooltip", () -> !this.modelsNamesDisabled.contains((Object)fileName), value -> {
                    if (value.booleanValue()) {
                        this.modelsNamesDisabled.remove((Object)fileName);
                    } else {
                        this.modelsNamesDisabled.add((Object)fileName);
                    }
                }, true), new TConfigEntryCategory("entity_model_features.config.models.part_names").addAll(this.getmappings(mapData.getMapId())), this.getExport((OptifineMobNameForFileAndEMFMapId)mapData, layer)});
                model.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)("assets/" + mapData.getNamespace() + "/optifine/cem/" + mapData.getfileName() + ".jem\nassets/" + mapData.getNamespace() + "/emf/cem/" + mapData.getfileName() + ".jem\n"), (int)100, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
            }
        });
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.arrows", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        category.addAll((Collection)TConfigEntryText.fromLongOrMultilineTranslation((String)"entity_model_features.config.models.cape", (int)200, (TConfigEntryText.TextAlignment)TConfigEntryText.TextAlignment.LEFT));
        return category;
    }

    @NotNull
    private TConfigEntry getExport(OptifineMobNameForFileAndEMFMapId key, class_5601 layer) {
        TConfigEntryText.TwoLines export;
        try {
            Objects.requireNonNull(key.getMapId());
            Objects.requireNonNull((class_5607)class_310.method_1551().method_31974().field_27542.get(layer));
            export = new TConfigEntryCustomButton("entity_model_features.config.models.export", "entity_model_features.config.models.export.tooltip", button -> {
                ModelPrintMode old = this.modelExportMode;
                this.modelExportMode = ModelPrintMode.ALL_LOG_AND_JEM;
                try {
                    EMFOptiFinePartNameMappings.getMapOf(key.getMapId(), ((class_5607)class_310.method_1551().method_31974().field_27542.get(layer)).method_32109(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.modelExportMode = old;
                button.field_22763 = false;
                button.method_25355((class_2561)class_2561.method_43471((String)"entity_model_features.config.models.export.success"));
            });
        }
        catch (Exception e) {
            export = new TConfigEntryText.TwoLines("entity_model_features.config.models.export.fail", e.getMessage());
        }
        return export;
    }

    private Collection<TConfigEntry> getmappings(String mapKey) {
        Map<String, String> map;
        ArrayList<TConfigEntry> list = new ArrayList<TConfigEntry>();
        if (EMFOptiFinePartNameMappings.OPTIFINE_MODEL_MAP_CACHE.containsKey(mapKey)) {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.optifine_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFOptiFinePartNameMappings.OPTIFINE_MODEL_MAP_CACHE.get(mapKey);
        } else {
            list.add((TConfigEntry)new TConfigEntryText("entity_model_features.config.variable_explanation.unknown_parts"));
            list.add((TConfigEntry)new TConfigEntryText("\\/"));
            map = EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.get(mapKey);
        }
        if (map == null) {
            return List.of();
        }
        for (String entry : map.keySet()) {
            list.add((TConfigEntry)new TConfigEntryText(entry));
        }
        return list;
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            class_7923.field_41177.forEach(entityType -> {
                String translationKey = entityType.method_5882();
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
            class_5616.field_27752.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey((class_2591)entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntityConfigs(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return category;
    }

    private void addEntityConfigs(TConfigEntryCategory entityCategory, String translationKey) {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.models_main");
        entityCategory.add((TConfigEntry)category);
        category.add(new TConfigEntry[]{new TConfigEntryEnumSlider("entity_model_features.config.render", "entity_model_features.config.render.tooltip", () -> (RenderModeChoice)this.entityRenderModeOverrides.getNullable(translationKey), layer -> this.entityRenderModeOverrides.putNullable(translationKey, (Enum)layer), null, RenderModeChoice.class), new TConfigEntryEnumButton("entity_model_features.config.vanilla_render", "entity_model_features.config.vanilla_render.tooltip", () -> (VanillaModelRenderMode)this.entityVanillaHologramOverrides.getNullable(translationKey), layer -> this.entityVanillaHologramOverrides.putNullable(translationKey, (Enum)layer), null, VanillaModelRenderMode.class), new TConfigEntryEnumButton("entity_model_features.config.physics", "entity_model_features.config.physics.tooltip", () -> (PhysicsModCompatChoice)this.entityPhysicsModPatchOverrides.getNullable(translationKey), layer -> this.entityPhysicsModPatchOverrides.putNullable(translationKey, (Enum)layer), null, PhysicsModCompatChoice.class)});
    }

    public class_2960 getModIcon() {
        return EMFUtils.res("entity_model_features", "textures/gui/icon.png");
    }

    public static enum RenderModeChoice {
        NORMAL((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.normal")),
        GREEN((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.green")),
        LINES_AND_TEXTURE((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.lines_texture")),
        LINES_AND_TEXTURE_FLASH((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.lines_texture_flash")),
        LINES((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.lines")),
        NONE((class_2561)class_2561.method_43471((String)"entity_model_features.config.render.none"));

        private final String text;

        private RenderModeChoice(class_2561 text) {
            this.text = text.getString();
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum VanillaModelRenderMode {
        OFF(class_5244.field_24333),
        NORMAL((class_2561)class_2561.method_43471((String)"entity_model_features.config.vanilla_render.normal")),
        OFFSET((class_2561)class_2561.method_43471((String)"entity_model_features.config.vanilla_render.offset"));

        private final class_2561 text;

        private VanillaModelRenderMode(class_2561 text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum ModelPrintMode {
        NONE(class_5244.field_24333),
        LOG_ONLY((class_2561)class_2561.method_43471((String)"entity_model_features.config.print_mode.log")),
        LOG_AND_JEM((class_2561)class_2561.method_43471((String)"entity_model_features.config.print_mode.log_jem")),
        ALL_LOG_ONLY((class_2561)class_2561.method_43471((String)"entity_model_features.config.print_mode.all_log")),
        ALL_LOG_AND_JEM((class_2561)class_2561.method_43471((String)"entity_model_features.config.print_mode.all_log_jem"));

        private final class_2561 text;

        private ModelPrintMode(class_2561 text) {
            this.text = text;
        }

        public boolean doesJems() {
            return this == LOG_AND_JEM || this == ALL_LOG_AND_JEM;
        }

        public boolean doesAll() {
            return this == ALL_LOG_ONLY || this == ALL_LOG_AND_JEM;
        }

        public boolean doesLog() {
            return this != NONE;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum PhysicsModCompatChoice {
        OFF(class_5244.field_24333),
        VANILLA((class_2561)class_2561.method_43471((String)"entity_model_features.config.physics.1")),
        CUSTOM((class_2561)class_2561.method_43471((String)"entity_model_features.config.physics.2"));

        private final class_2561 text;

        private PhysicsModCompatChoice(class_2561 text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    private static class ModelRootRenderer
    implements TConfigScreenList.Renderable {
        private final class_5601 layer;
        private class_630 root = null;
        private boolean asserted = false;

        ModelRootRenderer(class_5601 layer) {
            this.layer = layer;
        }

        private boolean canRender() {
            if (!this.asserted && this.root == null) {
                this.asserted = true;
                try {
                    this.root = ((class_5607)class_310.method_1551().method_31974().field_27542.get(this.layer)).method_32109();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.root != null;
        }

        public void render(class_332 context, int mouseX, int mouseY) {
            if (this.canRender()) {
                class_437 screen = class_310.method_1551().field_1755;
                if (screen == null) {
                    return;
                }
                int y = (int)((double)screen.field_22790 * 0.75);
                int x = (int)((double)screen.field_22789 * 0.33);
                float g = (float)(-Math.atan(((float)(-mouseY) + (float)screen.field_22790 / 2.0f) / 40.0f));
                float g2 = (float)(-Math.atan(((float)(-mouseX) + (float)screen.field_22789 / 3.0f) / 400.0f));
                Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY(g2 * 8.0f);
                Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)) * 2.0f);
                quaternionf.mul((Quaternionfc)quaternionf2);
                context.method_51448().method_22903();
                context.method_51448().method_22904((double)x, (double)y, 150.0);
                float scaling = (float)((double)screen.field_22790 * 0.3);
                context.method_51448().method_34425(new Matrix4f().scaling(scaling, scaling, -scaling));
                context.method_51448().method_22907(quaternionf);
                class_308.method_34742();
                class_4587 matrixStack = context.method_51448();
                matrixStack.method_22903();
                matrixStack.method_22905(-1.0f, -1.0f, 1.0f);
                matrixStack.method_46416(0.0f, -1.501f, 0.0f);
                class_4588 buffer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
                if (buffer != null) {
                    this.renderBoxes(matrixStack, buffer, this.root);
                }
                matrixStack.method_22909();
            }
        }

        private void renderBoxes(class_4587 matrices, class_4588 vertices, class_630 modelPart) {
            if (!(!modelPart.field_3665 || modelPart.field_3663.isEmpty() && modelPart.field_3661.isEmpty())) {
                matrices.method_22903();
                modelPart.method_22703(matrices);
                if (!modelPart.field_38456) {
                    for (class_630.class_628 cuboid : modelPart.field_3663) {
                        class_238 box = new class_238((double)(cuboid.field_3645 / 16.0f), (double)(cuboid.field_3644 / 16.0f), (double)(cuboid.field_3643 / 16.0f), (double)(cuboid.field_3648 / 16.0f), (double)(cuboid.field_3647 / 16.0f), (double)(cuboid.field_3646 / 16.0f));
                        class_761.method_22982((class_4587)matrices, (class_4588)vertices, (class_238)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                for (class_630 modelPartChildren : modelPart.field_3661.values()) {
                    this.renderBoxes(matrices, vertices, modelPartChildren);
                }
                matrices.method_22909();
            }
        }
    }
}

