/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.function.Function;

public class BlurConfig
extends MidnightConfig {
    public static final String ANIMATIONS = "animations";
    public static final String STYLE = "style";
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static int configVersion = 2;
    @MidnightConfig.Entry(category="style")
    public static boolean blurContainers = true;
    @MidnightConfig.Entry(category="animations", min=0.0, max=2000.0, isSlider=true)
    public static int fadeTimeMillis = 300;
    @MidnightConfig.Entry(category="animations", min=0.0, max=2000.0, isSlider=true)
    public static int fadeOutTimeMillis = 300;
    @MidnightConfig.Entry(category="animations")
    public static Easing animationCurve = Easing.FLAT;
    @MidnightConfig.Entry(category="style")
    public static boolean useGradient = true;
    @MidnightConfig.Entry(category="style", isColor=true, width=7, min=7.0)
    public static String gradientStart = "#000000";
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=255.0)
    public static int gradientStartAlpha = 75;
    @MidnightConfig.Entry(category="style", isColor=true, width=7, min=7.0)
    public static String gradientEnd = "#000000";
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=255.0)
    public static int gradientEndAlpha = 75;
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=360.0)
    public static int gradientRotation = 0;
    @MidnightConfig.Entry(category="style")
    public static boolean rainbowMode = false;
    @MidnightConfig.Entry(category="style")
    public static List<String> excludedScreens = Lists.newArrayList((Object[])new String[]{"net.irisshaders.iris.gui.screen.ShaderPackScreen"});

    public static enum Easing {
        FLAT(x -> x, x -> x),
        SINE(x -> 1.0 - Math.cos(x * Math.PI) / 2.0, x -> Math.sin(x * Math.PI) / 2.0),
        QUAD(x -> x * x, x -> 1.0 - (1.0 - x) * (1.0 - x)),
        CUBIC(x -> x * x * x, x -> 1.0 - Math.pow(1.0 - x, 3.0)),
        QUART(x -> x * x * x * x, x -> 1.0 - Math.pow(1.0 - x, 4.0)),
        QUINT(x -> x * x * x * x * x, x -> 1.0 - Math.pow(1.0 - x, 5.0)),
        EXPO(x -> x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0), x -> x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x)),
        CIRC(x -> 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)), x -> Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0))),
        BACK(x -> 2.70158 * x * x * x - 1.70158 * x * x, x -> 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0)),
        ELASTIC(x -> x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953)), x -> x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * 2.0943951023931953) + 1.0));

        final Function<Double, Number> functionIn;
        final Function<Double, Number> functionOut;

        private Easing(Function<Double, Number> functionIn, Function<Double, Number> functionOut) {
            this.functionIn = functionIn;
            this.functionOut = functionOut;
        }

        public Double apply(Double x, boolean in) {
            if (in) {
                return this.functionIn.apply(x).doubleValue();
            }
            return this.functionOut.apply(x).doubleValue();
        }
    }
}

