/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur;

import eu.midnightdust.blur.config.BlurConfig;
import eu.midnightdust.blur.util.RainbowColor;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_332;
import org.joml.Math;

public class Blur
implements ClientModInitializer {
    public static long start;
    public static float progress;
    public static boolean prevScreenHasBlur;
    public static boolean screenHasBlur;
    public static boolean prevScreenHasBackground;
    public static boolean screenHasBackground;
    public static boolean doTest;
    public static boolean screenChanged;
    public static long lastScreenChange;
    public static boolean doFade;

    public void onInitializeClient() {
        BlurConfig.init((String)"blur", BlurConfig.class);
        ClientTickEvents.END_CLIENT_TICK.register(RainbowColor::tick);
    }

    public static void onScreenChange() {
        if (screenHasBlur) {
            if (doFade) {
                start = System.currentTimeMillis();
                doFade = false;
            }
        } else if (prevScreenHasBlur && BlurConfig.fadeOutTimeMillis > 0) {
            start = System.currentTimeMillis();
            doFade = true;
        } else {
            start = -1L;
            doFade = true;
        }
    }

    public static void updateProgress(boolean fadeIn) {
        double x;
        if (fadeIn) {
            x = Math.min((double)((double)(System.currentTimeMillis() - start) / (double)BlurConfig.fadeTimeMillis), (double)1.0);
        } else {
            x = Math.max((double)(1.0 + (double)(start - System.currentTimeMillis()) / (double)BlurConfig.fadeOutTimeMillis), (double)0.0);
            if (x <= 0.0) {
                start = -1L;
            }
        }
        x = BlurConfig.animationCurve.apply(x, fadeIn);
        x = Math.clamp((double)0.0, (double)1.0, (double)x);
        progress = Double.valueOf(x).floatValue();
    }

    public static int getBackgroundColor(boolean second) {
        int a = second ? BlurConfig.gradientEndAlpha : BlurConfig.gradientStartAlpha;
        Color col = MidnightColorUtil.hex2Rgb((String)(second ? BlurConfig.gradientEnd : BlurConfig.gradientStart));
        if (BlurConfig.rainbowMode) {
            col = second ? Color.getHSBColor(RainbowColor.hue, 1.0f, 1.0f) : Color.getHSBColor(RainbowColor.hue2, 1.0f, 1.0f);
        }
        int r = col.getRGB() >> 16 & 0xFF;
        int b = col.getRGB() >> 8 & 0xFF;
        int g = col.getRGB() & 0xFF;
        float prog = progress;
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }

    public static int getRotation() {
        if (BlurConfig.rainbowMode) {
            return RainbowColor.rotation;
        }
        return BlurConfig.gradientRotation;
    }

    public static void renderRotatedGradient(class_332 context, int width, int height) {
        float diagonal = Math.sqrt((float)((float)width * (float)width + (float)(height * height)));
        int smallestDimension = Math.min((int)width, (int)height);
        context.method_51448().method_23760().method_23761().rotationZ(Math.toRadians((float)Blur.getRotation()));
        context.method_51448().method_23760().method_23761().setTranslation((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        context.method_51448().method_23760().method_23761().scale(diagonal / (float)smallestDimension);
        context.method_25296(-width / 2, -height / 2, width / 2, height / 2, Blur.getBackgroundColor(false), Blur.getBackgroundColor(true));
        context.method_51448().method_23760().method_23761().rotationZ(0.0f);
    }

    static {
        doTest = true;
        screenChanged = true;
        lastScreenChange = System.currentTimeMillis();
        doFade = false;
    }
}

