/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.google.gson.annotations.SerializedName;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.BatteryTrackerConfig;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.IdleConfig;
import dynamic_fps.impl.config.Serialization;
import dynamic_fps.impl.config.VolumeTransitionConfig;
import java.util.Map;

public final class DynamicFPSConfig {
    private boolean enabled;
    private boolean uncapMenuFrameRate;
    private IdleConfig idle;
    private BatteryTrackerConfig batteryTracker;
    private VolumeTransitionConfig volumeTransitionSpeed;
    private boolean downloadNatives;
    @SerializedName(value="states")
    private Map<PowerState, Config> configs;
    public static final DynamicFPSConfig DEFAULTS = Serialization.loadDefault();
    public static final DynamicFPSConfig INSTANCE = Serialization.loadPersonalized();

    public Config get(PowerState state) {
        if (state == PowerState.FOCUSED) {
            return Config.ACTIVE;
        }
        return this.configs.get((Object)state);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public IdleConfig idle() {
        return this.idle;
    }

    public BatteryTrackerConfig batteryTracker() {
        return this.batteryTracker;
    }

    public VolumeTransitionConfig volumeTransitionSpeed() {
        return this.volumeTransitionSpeed;
    }

    public boolean uncapMenuFrameRate() {
        return this.uncapMenuFrameRate;
    }

    public void setUncapMenuFrameRate(boolean value) {
        this.uncapMenuFrameRate = value;
    }

    public boolean downloadNatives() {
        return this.downloadNatives;
    }

    public void setDownloadNatives(boolean value) {
        this.downloadNatives = value;
    }

    public void save() {
        Serialization.save(this);
    }

    static {
        for (Map.Entry<PowerState, Config> entry : DynamicFPSConfig.INSTANCE.configs.entrySet()) {
            entry.getValue().state = entry.getKey();
        }
    }
}

