/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5630;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiManagerItem
extends GuiManager {
    private class_1799 hand = class_1799.field_8037;
    private boolean drag;
    private boolean rightClick;
    private List<GuiSlot> dragged;
    private List<Integer> stackSizes;
    private boolean handChanged;
    public class_5630 handAccess = new class_5630(){

        public class_1799 method_32327() {
            return GuiManagerItem.this.getHand();
        }

        public boolean method_32332(class_1799 hand) {
            GuiManagerItem.this.setHand(hand);
            return true;
        }
    };

    public static int freeSpace(class_1735 slot, class_1799 hand) {
        if (slot.method_7680(hand) && class_1703.method_7592((class_1735)slot, (class_1799)hand, (boolean)true)) {
            int stackSize = slot.method_7676(hand);
            if (slot.method_7681()) {
                stackSize -= slot.method_7677().method_7947();
            }
            return stackSize;
        }
        return -1;
    }

    public GuiManagerItem(GuiLayer layer) {
        super(layer);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderOverlay(class_332 graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        class_1799 stack = this.hand;
        int count = stack.method_7947();
        if (this.drag) {
            int used = 0;
            int countPerSlot = Math.max(1, class_3532.method_15375((float)((float)this.hand.method_7947() / (float)this.stackSizes.size())));
            if (this.rightClick) {
                countPerSlot = 1;
            }
            for (int i = 0; i < this.stackSizes.size(); ++i) {
                used += Math.min(countPerSlot, this.stackSizes.get(i));
            }
            int left = this.hand.method_7947() - used;
            count = Math.max(0, left);
        }
        if (!(stack.method_7960() || this.drag && !this.rightClick && this.dragged.size() <= 1)) {
            class_4587 pose = graphics.method_51448();
            pose.method_22903();
            RenderSystem.disableScissor();
            pose.method_46416((float)(mouseX - 8), (float)(mouseY - 8), 200.0f);
            GuiRenderHelper.drawItemStack(pose, stack, 1.0f);
            graphics.method_51432(GuiRenderHelper.getFont(), stack, 0, 0, "" + count);
            pose.method_22909();
        }
    }

    @Override
    public void tick() {
        if (this.handChanged) {
            this.handChanged = false;
            if (!this.layer.isClient()) {
                CreativeCoreGuiRegistry.HAND.send(this.layer, (class_2487)this.hand.method_57376(this.layer.provider(), (class_2520)new class_2487()));
            }
        }
        super.tick();
    }

    @Override
    public void closed() {
        if (!(this.layer.isClient() || this.hand.method_7960() || this.layer.getPlayer().method_7270(this.hand))) {
            this.layer.getPlayer().method_7328(this.hand, false);
        }
        super.closed();
    }

    @Override
    public void mouseClickedOutside(double x, double y) {
        if (!this.hand.method_7960()) {
            CreativeCoreGuiRegistry.DROP_HAND.send(this.layer, class_2491.field_21033);
        }
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        if (this.isDragged() && this.rightClick == (button == 1)) {
            this.endDrag();
        }
    }

    public void startDrag(GuiSlot slot, boolean rightClick, int stackSize) {
        this.drag = true;
        this.dragged = new ArrayList<GuiSlot>();
        this.dragged.add(slot);
        this.rightClick = rightClick;
        this.stackSizes = new ArrayList<Integer>();
        this.stackSizes.add(stackSize);
        slot.draggedIndex = 0;
    }

    public void addToDrag(GuiSlot slot) {
        int stackSize = GuiManagerItem.freeSpace(slot.slot, this.hand);
        if (stackSize > 0) {
            slot.draggedIndex = this.dragged.size();
            this.dragged.add(slot);
            this.stackSizes.add(stackSize);
        }
    }

    public void modifyDrag(GuiSlot slot) {
        this.stackSizes.set(slot.draggedIndex, GuiManagerItem.freeSpace(slot.slot, this.hand));
    }

    public void abortDrag() {
        for (GuiSlot slot : this.dragged) {
            slot.draggedIndex = -1;
        }
        this.drag = false;
        this.rightClick = false;
        this.dragged = null;
        this.stackSizes = null;
    }

    public void endDrag() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("rightClick", this.rightClick);
        HashMap<String, Integer> inventories = new HashMap<String, Integer>();
        class_2499 names = new class_2499();
        int[] ids = new int[this.dragged.size() * 2];
        int i = 0;
        for (GuiSlot slot : this.dragged) {
            String inventory = slot.inventory().name();
            Integer inventoryId = (Integer)inventories.get(inventory);
            if (inventoryId == null) {
                inventoryId = inventories.size();
                inventories.put(inventory, inventoryId);
                names.add((Object)class_2519.method_23256((String)inventory));
            }
            ids[i] = inventoryId;
            ids[i + 1] = slot.slot.method_34266();
            i += 2;
        }
        nbt.method_10539("ids", ids);
        nbt.method_10566("names", (class_2520)names);
        CreativeCoreGuiRegistry.SPREAD.sendAndExecute(this.layer, nbt);
        if (this.isDragged()) {
            this.abortDrag();
        }
    }

    public boolean isDragged() {
        return this.drag;
    }

    public class_1799 getHand() {
        return this.hand;
    }

    public void setHandChanged() {
        this.handChanged = true;
    }

    public void setHand(class_1799 stack) {
        if (this.isDragged()) {
            this.abortDrag();
        }
        this.hand = stack;
        this.setHandChanged();
    }

    public int additionalDragCount(int index) {
        if (index >= this.hand.method_7947()) {
            return 0;
        }
        if (this.rightClick) {
            return 1;
        }
        return Math.max(1, class_3532.method_15375((float)((float)this.hand.method_7947() / (float)this.dragged.size())));
    }
}

