/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.util.Type;
import net.irisshaders.iris.gl.shader.ShaderType;
import net.irisshaders.iris.pipeline.transform.parameter.SodiumParameters;
import net.irisshaders.iris.pipeline.transform.transformer.CommonTransformer;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;

public class SodiumTransformer {
    public static void transform(ASTParser t, TranslationUnit tree, Root root, SodiumParameters parameters) {
        CommonTransformer.transform(t, tree, root, parameters, false);
        SodiumTransformer.replaceMidTexCoord(t, tree, root, 3.0517578E-5f);
        root.replaceExpressionMatches(t, CommonTransformer.glTextureMatrix0, "mat4(1.0)");
        root.replaceExpressionMatches(t, CommonTransformer.glTextureMatrix1, "iris_LightmapTextureMatrix");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_FUNCTIONS, "uniform mat4 iris_LightmapTextureMatrix;");
        root.rename("gl_ProjectionMatrix", "iris_ProjectionMatrix");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            root.rename("gl_MultiTexCoord2", "gl_MultiTexCoord1");
            if (parameters.inputs.hasTex()) {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord0", "vec4(_vert_tex_diffuse_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord0", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            if (parameters.inputs.hasLight()) {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord1", "vec4(_vert_tex_light_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(t, "gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            }
            CommonTransformer.patchMultiTexCoord3(t, tree, root, parameters);
            CommonTransformer.replaceGlMultiTexCoordBounded(t, root, 4, 7);
        }
        if (parameters.inputs.hasColor()) {
            root.rename("gl_Color", "_vert_color");
        } else {
            root.replaceReferenceExpressions(t, "gl_Color", "vec4(1.0)");
        }
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            if (parameters.inputs.hasNormal()) {
                root.rename("gl_Normal", "iris_Normal");
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec3 iris_Normal;");
            } else {
                root.replaceReferenceExpressions(t, "gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        root.replaceReferenceExpressions(t, "gl_NormalMatrix", "iris_NormalMatrix");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat3 iris_NormalMatrix;");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatrixInverse;");
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ProjectionMatrixInverse;");
        root.rename("gl_ModelViewMatrix", "iris_ModelViewMatrix");
        root.rename("gl_ModelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        root.rename("gl_ProjectionMatrixInverse", "iris_ProjectionMatrixInverse");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            if (root.identifierIndex.has("ftransform")) {
                tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }"});
            }
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_ProjectionMatrix;", "uniform mat4 iris_ModelViewMatrix;", "uniform vec3 u_RegionOffset;", "vec4 getVertexPosition() { return vec4(_vert_position + u_RegionOffset + _get_draw_translation(_draw_id), 1.0); }"});
            root.replaceReferenceExpressions(t, "gl_Vertex", "getVertexPosition()");
            SodiumTransformer.injectVertInit(t, tree, root, parameters);
        } else {
            tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_ModelViewMatrix;", "uniform mat4 iris_ProjectionMatrix;"});
        }
        root.replaceReferenceExpressions(t, "gl_ModelViewProjectionMatrix", "(iris_ProjectionMatrix * iris_ModelViewMatrix)");
        CommonTransformer.applyIntelHd4000Workaround(root);
    }

    public static void injectVertInit(ASTParser t, TranslationUnit tree, Root root, SodiumParameters parameters) {
        String separateAo = WorldRenderingSettings.INSTANCE.shouldUseSeparateAo() ? "a_Color" : "vec4(a_Color.rgb * a_Color.a, 1.0)";
        tree.parseAndInjectNodes(t, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec3 _vert_position;", "vec2 _vert_tex_diffuse_coord;", "ivec2 _vert_tex_light_coord;", "vec4 _vert_color;", "uint _draw_id;", "const uint MATERIAL_USE_MIP_OFFSET = 0u;", "float _material_mip_bias(uint material) {\n    return ((material >> MATERIAL_USE_MIP_OFFSET) & 1u) != 0u ? 0.0f : -4.0f;\n}", "void _vert_init() {_vert_position = (vec3(a_PosId.xyz) * 0.00048828125 + -8.0);_vert_tex_diffuse_coord = (a_TexCoord * 3.0517578E-5);_vert_tex_light_coord = a_LightCoord;_vert_color = " + separateAo + ";_draw_id = (a_PosId.w >> 8u) & 0xFFu; }", "uvec3 _get_relative_chunk_coord(uint pos) {\n    // Packing scheme is defined by LocalSectionIndex\n    return uvec3(pos) >> uvec3(5u, 0u, 2u) & uvec3(7u, 3u, 7u);\n}", "vec3 _get_draw_translation(uint pos) {\n    return _get_relative_chunk_coord(pos) * vec3(16.0f);\n}\n"});
        CommonTransformer.addIfNotExists(root, t, tree, "a_PosId", Type.U32VEC4, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, t, tree, "a_TexCoord", Type.F32VEC2, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, t, tree, "a_Color", Type.F32VEC4, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, t, tree, "a_LightCoord", Type.I32VEC2, StorageQualifier.StorageType.IN);
        tree.prependMainFunctionBody(t, "_vert_init();");
    }

    public static void replaceMidTexCoord(ASTParser t, TranslationUnit tree, Root root, float textureScale) {
        Type dimension = Type.BOOL;
        for (Identifier id : root.identifierIndex.get("mc_midTexCoord")) {
            TypeSpecifier typeSpecifier;
            DeclarationExternalDeclaration declaration;
            TypeAndInitDeclaration initDeclaration = (TypeAndInitDeclaration)id.getAncestor(2, 0, TypeAndInitDeclaration.class::isInstance);
            if (initDeclaration == null || (declaration = (DeclarationExternalDeclaration)initDeclaration.getAncestor(1, 0, DeclarationExternalDeclaration.class::isInstance)) == null || !((typeSpecifier = initDeclaration.getType().getTypeSpecifier()) instanceof BuiltinNumericTypeSpecifier)) continue;
            BuiltinNumericTypeSpecifier numeric = (BuiltinNumericTypeSpecifier)typeSpecifier;
            dimension = numeric.type;
            declaration.detachAndDelete();
            initDeclaration.detachAndDelete();
            id.detachAndDelete();
            break;
        }
        root.replaceReferenceExpressions(t, "mc_midTexCoord", "iris_MidTex");
        switch (dimension) {
            case BOOL: {
                return;
            }
            case FLOAT32: {
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "float iris_MidTex = (mc_midTexCoord.x * " + textureScale + ").x;");
                break;
            }
            case F32VEC2: {
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec2 iris_MidTex = (mc_midTexCoord.xy * " + textureScale + ").xy;");
                break;
            }
            case F32VEC3: {
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec3 iris_MidTex = vec3(mc_midTexCoord.xy * " + textureScale + ", 0.0);");
                break;
            }
            case F32VEC4: {
                tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "vec4 iris_MidTex = vec4(mc_midTexCoord.xy * " + textureScale + ", 0.0, 1.0);");
                break;
            }
            default: {
                throw new IllegalStateException("Somehow got a midTexCoord that is *above* 4 dimensions???");
            }
        }
        tree.parseAndInjectNode(t, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec2 mc_midTexCoord;");
    }
}

