/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.networking.packet;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.chain.IncompleteChainLink;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.util.Helper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ChainAttachPayload(int primaryEntityId, int secondaryEntityId, int chainTypeId, boolean attach) implements class_8710
{
    public static final class_8710.class_9154<ChainAttachPayload> PAYLOAD_ID = new class_8710.class_9154(Helper.identifier("s2c_chain_attach_packet_id"));
    public static final class_9139<class_9129, ChainAttachPayload> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.field_49675, ChainAttachPayload::primaryEntityId, (class_9139)class_9135.field_49675, ChainAttachPayload::secondaryEntityId, (class_9139)class_9135.field_49675, ChainAttachPayload::chainTypeId, (class_9139)class_9135.field_48547, ChainAttachPayload::attach, ChainAttachPayload::new);
    public static final ObjectList<IncompleteChainLink> incompleteLinks = new ObjectArrayList(256);

    public ChainAttachPayload(ChainLink link, boolean attach) {
        this(link.getPrimary().method_5628(), link.getSecondary().method_5628(), class_7923.field_41178.method_10206((Object)link.getSourceItem()), attach);
    }

    public ChainAttachPayload(class_2540 buf) {
        this(buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean());
    }

    public static void encode(class_2540 buf1, ChainAttachPayload packet) {
        buf1.method_53002(packet.primaryEntityId());
        buf1.method_53002(packet.secondaryEntityId());
        buf1.method_53002(packet.chainTypeId());
        buf1.method_52964(packet.attach());
    }

    private void applyDetach(class_746 clientPlayerEntity, PacketSender packetSender) {
        class_638 world = clientPlayerEntity.field_17892;
        class_1297 primary = world.method_8469(this.primaryEntityId);
        if (!(primary instanceof ChainKnotEntity)) {
            ConnectibleChains.LOGGER.warn(String.format("Tried to detach from %s (#%d) which is not a chain knot", primary, this.primaryEntityId));
            return;
        }
        ChainKnotEntity primaryKnot = (ChainKnotEntity)primary;
        class_1297 secondary = world.method_8469(this.secondaryEntityId);
        incompleteLinks.removeIf(link -> {
            if (link.primary == primaryKnot && link.secondaryId == this.secondaryEntityId) {
                link.destroy();
                return true;
            }
            return false;
        });
        if (secondary == null) {
            return;
        }
        for (ChainLink link2 : primaryKnot.getLinks()) {
            if (link2.getSecondary() != secondary) continue;
            link2.destroy(true);
        }
    }

    private void applyAttach(class_746 clientPlayerEntity, PacketSender packetSender) {
        class_638 world = clientPlayerEntity.field_17892;
        class_1297 primary = world.method_8469(this.primaryEntityId);
        if (!(primary instanceof ChainKnotEntity)) {
            ConnectibleChains.LOGGER.warn(String.format("Tried to attach from %s (#%d) which is not a chain knot", primary, this.primaryEntityId));
            return;
        }
        ChainKnotEntity primaryKnot = (ChainKnotEntity)primary;
        class_1297 secondary = world.method_8469(this.secondaryEntityId);
        class_1792 chainType = (class_1792)class_7923.field_41178.method_10200(this.chainTypeId);
        if (secondary == null) {
            incompleteLinks.add((Object)new IncompleteChainLink(primaryKnot, this.secondaryEntityId, chainType));
        } else {
            ChainLink.create(primaryKnot, secondary, chainType);
        }
    }

    public class_8710.class_9154<ChainAttachPayload> method_56479() {
        return PAYLOAD_ID;
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(ClientPlayNetworking.Context context) {
        if (this.attach) {
            this.applyAttach(context.player(), context.responseSender());
            return;
        }
        this.applyDetach(context.player(), context.responseSender());
    }
}

