/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.entity;

import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.entity.ChainLinkEntity;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCollisionEntity
extends class_1297
implements ChainLinkEntity {
    @Nullable
    private ChainLink link;

    public ChainCollisionEntity(class_1937 world, double x, double y, double z, @NotNull ChainLink link) {
        this(ModEntityTypes.CHAIN_COLLISION, world);
        this.link = link;
        this.method_5814(x, y, z);
    }

    public ChainCollisionEntity(class_1299<? extends ChainCollisionEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Nullable
    public ChainLink getLink() {
        return this.link;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5810() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_24520(itemStack -> itemStack.method_31573(ConventionalItemTags.SHEAR_TOOLS))) {
            return super.method_5640(distance);
        }
        return false;
    }

    public boolean method_5753() {
        return super.method_5753();
    }

    protected void method_5749(class_2487 tag) {
    }

    protected void method_5652(class_2487 tag) {
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 playerEntity = (class_1657)attacker;
            this.method_5643(this.method_48923().method_48802(playerEntity), 0.0f);
        } else {
            this.method_5783(this.getHitSound(), 0.5f, 1.0f);
        }
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1269 result = ChainLinkEntity.onDamageFrom(this, source, this.getHitSound());
        if (result.method_23665()) {
            this.destroyLinks(result == class_1269.field_5812);
            return true;
        }
        return false;
    }

    @Override
    public void destroyLinks(boolean mayDrop) {
        if (this.link != null) {
            this.link.destroy(mayDrop);
        }
    }

    private class_3414 getHitSound() {
        if (this.link != null) {
            return ChainLink.getSoundGroup(this.link.sourceItem).method_10596();
        }
        return ChainLink.getSoundGroup(null).method_10596();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (ChainLinkEntity.canDestroyWith(player.method_5998(hand))) {
            this.destroyLinks(!player.method_7337());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void method_5773() {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.link != null && this.link.needsBeDestroyed()) {
            this.link.destroy(true);
        }
        if (this.link == null || this.link.isDead()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }
}

