/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client.render.entity.texture;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.client.ClientInitializer;
import com.github.legoatoom.connectiblechains.util.Helper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class ChainTextureManager
implements SimpleResourceReloadListener<Map<class_2960, JsonElement>> {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String MODEL_FILE_LOCATION = "models/entity/connectiblechains";
    private static final int EXPECTED_UNIQUE_CHAIN_COUNT = 64;
    private final Object2ObjectMap<class_2960, class_2960> chainTextures = new Object2ObjectOpenHashMap(64);
    private final Object2ObjectMap<class_2960, class_2960> knotTextures = new Object2ObjectOpenHashMap(64);

    public class_2960 getFabricId() {
        return Helper.identifier("chain_models");
    }

    public CompletableFuture<Map<class_2960, JsonElement>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap map = new HashMap();
            class_4309.method_51148((class_3300)manager, (String)MODEL_FILE_LOCATION, (Gson)GSON, map);
            return map;
        });
    }

    public CompletableFuture<Void> apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            this.clearCache();
            data.forEach((identifier, jsonElement) -> {
                class_3545<class_2960, class_2960> textures = ChainTextureManager.extractChainTextures(identifier, jsonElement);
                this.chainTextures.put(identifier, (Object)((class_2960)textures.method_15442()));
                this.knotTextures.put(identifier, (Object)((class_2960)textures.method_15441()));
            });
            return null;
        });
    }

    private static class_3545<class_2960, class_2960> extractChainTextures(class_2960 itemId, JsonElement jsonElement) {
        class_2960 chainTextureId = ChainTextureManager.defaultChainTextureId(itemId);
        class_2960 knotTextureId = ChainTextureManager.defaultKnotTextureId(itemId);
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject texturesObject = jsonObject.getAsJsonObject("textures");
            if (texturesObject.has("chain") && texturesObject.get("chain").isJsonPrimitive()) {
                chainTextureId = class_2960.method_12829((String)(texturesObject.get("chain").getAsString() + ".png"));
            }
            if (texturesObject.has("knot") && texturesObject.get("knot").isJsonPrimitive()) {
                knotTextureId = class_2960.method_12829((String)(texturesObject.get("knot").getAsString() + ".png"));
            }
        }
        return new class_3545((Object)chainTextureId, (Object)knotTextureId);
    }

    public void clearCache() {
        ClientInitializer.getInstance().getChainKnotEntityRenderer().ifPresent(it -> it.getChainRenderer().purge());
        this.chainTextures.clear();
        this.knotTextures.clear();
    }

    @NotNull
    private static class_2960 defaultChainTextureId(class_2960 itemId) {
        return class_2960.method_60655((String)itemId.method_12836(), (String)"textures/block/%s.png".formatted(itemId.method_12832()));
    }

    @NotNull
    private static class_2960 defaultKnotTextureId(class_2960 itemId) {
        return class_2960.method_60655((String)itemId.method_12836(), (String)"textures/item/%s.png".formatted(itemId.method_12832()));
    }

    public class_2960 getChainTexture(class_2960 sourceItemId) {
        return (class_2960)this.chainTextures.computeIfAbsent((Object)sourceItemId, id -> {
            ConnectibleChains.LOGGER.warn("Did not find a model file for the chain '%s', assuming default path.".formatted(sourceItemId));
            return ChainTextureManager.defaultChainTextureId(id);
        });
    }

    public class_2960 getKnotTexture(class_2960 sourceItemId) {
        return (class_2960)this.knotTextures.computeIfAbsent((Object)sourceItemId, id -> {
            ConnectibleChains.LOGGER.warn("Did not find a model file for the chain '%s', assuming default path.".formatted(sourceItemId));
            return ChainTextureManager.defaultKnotTextureId(id);
        });
    }
}

