/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.client;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainLink;
import com.github.legoatoom.connectiblechains.client.ChainPacketHandler;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainCollisionEntityRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.ChainKnotEntityRenderer;
import com.github.legoatoom.connectiblechains.client.render.entity.model.ChainKnotEntityModel;
import com.github.legoatoom.connectiblechains.client.render.entity.texture.ChainTextureManager;
import com.github.legoatoom.connectiblechains.config.ModConfig;
import com.github.legoatoom.connectiblechains.entity.ChainCollisionEntity;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.item.ChainItemInfo;
import com.github.legoatoom.connectiblechains.networking.packet.ConfigSyncPayload;
import com.github.legoatoom.connectiblechains.util.Helper;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1132;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3966;
import net.minecraft.class_5601;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public class ClientInitializer
implements ClientModInitializer {
    public static final class_5601 CHAIN_KNOT = new class_5601(Helper.identifier("chain_knot"), "main");
    private static ClientInitializer instance;
    private final ChainTextureManager chainTextureManager = new ChainTextureManager();
    private ChainKnotEntityRenderer chainKnotEntityRenderer;
    private ChainPacketHandler chainPacketHandler;

    public void onInitializeClient() {
        instance = this;
        this.initRenderers();
        this.registerNetworkEventHandlers();
        this.registerClientEventHandlers();
        ClientInitializer.registerConfigSync();
        ItemTooltipCallback.EVENT.register(ChainItemInfo::infoToolTip);
    }

    private static void registerConfigSync() {
        ConfigHolder configHolder = AutoConfig.getConfigHolder(ModConfig.class);
        configHolder.registerSaveListener((holder, modConfig) -> {
            class_1132 server;
            ClientInitializer clientInitializer = ClientInitializer.getInstance();
            if (clientInitializer != null) {
                clientInitializer.getChainKnotEntityRenderer().ifPresent(renderer -> renderer.getChainRenderer().purge());
            }
            if ((server = class_310.method_1551().method_1576()) != null) {
                ConnectibleChains.LOGGER.info("Syncing config to clients");
                ConnectibleChains.fileConfig.syncToClients((MinecraftServer)server);
                ConnectibleChains.runtimeConfig.copyFrom(ConnectibleChains.fileConfig);
            }
            return class_1269.field_5811;
        });
    }

    private void initRenderers() {
        ConnectibleChains.LOGGER.info("Initializing Renderers.");
        EntityRendererRegistry.register(ModEntityTypes.CHAIN_KNOT, ctx -> {
            this.chainKnotEntityRenderer = new ChainKnotEntityRenderer(ctx);
            return this.chainKnotEntityRenderer;
        });
        EntityRendererRegistry.register(ModEntityTypes.CHAIN_COLLISION, ChainCollisionEntityRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)CHAIN_KNOT, ChainKnotEntityModel::getTexturedModelData);
    }

    private void registerNetworkEventHandlers() {
        this.chainPacketHandler = new ChainPacketHandler();
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            ConnectibleChains.runtimeConfig.copyFrom(ConnectibleChains.fileConfig);
            this.getChainKnotEntityRenderer().ifPresent(r -> r.getChainRenderer().purge());
        });
        ClientPlayNetworking.registerGlobalReceiver(ConfigSyncPayload.PAYLOAD_ID, ConfigSyncPayload::apply);
    }

    private void registerClientEventHandlers() {
        ClientPickBlockGatherCallback.EVENT.register((player, result) -> {
            if (result instanceof class_3966) {
                class_1297 entity = ((class_3966)result).method_17782();
                if (entity instanceof ChainKnotEntity) {
                    ChainKnotEntity knot = (ChainKnotEntity)entity;
                    return new class_1799((class_1935)knot.getChainItemSource());
                }
                if (entity instanceof ChainCollisionEntity) {
                    ChainCollisionEntity collision = (ChainCollisionEntity)entity;
                    ChainLink link = collision.getLink();
                    if (link == null) {
                        return new class_1799((class_1935)class_1802.field_23983);
                    }
                    return new class_1799((class_1935)link.getSourceItem());
                }
            }
            return class_1799.field_8037;
        });
        ClientTickEvents.START_WORLD_TICK.register(world -> this.chainPacketHandler.tick());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this.chainTextureManager);
    }

    public static ClientInitializer getInstance() {
        return instance;
    }

    public Optional<ChainKnotEntityRenderer> getChainKnotEntityRenderer() {
        return Optional.ofNullable(this.chainKnotEntityRenderer);
    }

    public ChainTextureManager getChainTextureManager() {
        return this.chainTextureManager;
    }
}

