/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.chain;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.entity.ChainCollisionEntity;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.networking.packet.ChainAttachPayload;
import com.github.legoatoom.connectiblechains.util.Helper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1804;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainLink {
    private static final float COLLIDER_SPACING = 1.5f;
    @NotNull
    private final ChainKnotEntity primary;
    @NotNull
    private final class_1297 secondary;
    @NotNull
    public final class_1792 sourceItem;
    private final IntList collisionStorage = new IntArrayList(16);
    public boolean removeSilently = false;
    private boolean alive = true;

    private ChainLink(@NotNull ChainKnotEntity primary, @NotNull class_1297 secondary, @NotNull class_1792 sourceItem) {
        if (primary.equals(secondary)) {
            throw new IllegalStateException("Tried to create a link between a knot and itself");
        }
        this.primary = Objects.requireNonNull(primary);
        this.secondary = Objects.requireNonNull(secondary);
        this.sourceItem = Objects.requireNonNull(sourceItem);
    }

    @Nullable
    public static ChainLink create(@NotNull ChainKnotEntity primary, @NotNull class_1297 secondary, @NotNull class_1792 sourceItem) {
        ChainLink link = new ChainLink(primary, secondary, sourceItem);
        if (primary.getLinks().contains(link)) {
            return null;
        }
        primary.addLink(link);
        if (secondary instanceof ChainKnotEntity) {
            ChainKnotEntity secondaryKnot = (ChainKnotEntity)secondary;
            secondaryKnot.addLink(link);
            link.createCollision();
        }
        if (!primary.method_37908().method_8608()) {
            link.sendAttachChainPacket(primary.method_37908());
        }
        return link;
    }

    private void createCollision() {
        double step;
        if (!this.collisionStorage.isEmpty()) {
            return;
        }
        if (this.getPrimary().method_37908().field_9236) {
            return;
        }
        double distance = this.getPrimary().method_5739(this.getSecondary());
        double centerHoldout = (double)ModEntityTypes.CHAIN_COLLISION.method_17685() / distance;
        for (double v = step = 1.5 * Math.sqrt(Math.pow(ModEntityTypes.CHAIN_COLLISION.method_17685(), 2.0) * 2.0) / distance; v < 0.5 - centerHoldout; v += step) {
            class_1297 collider2;
            class_1297 collider1 = this.spawnCollision(false, (class_1297)this.getPrimary(), this.getSecondary(), v);
            if (collider1 != null) {
                this.collisionStorage.add(collider1.method_5628());
            }
            if ((collider2 = this.spawnCollision(true, (class_1297)this.getPrimary(), this.getSecondary(), v)) == null) continue;
            this.collisionStorage.add(collider2.method_5628());
        }
        class_1297 centerCollider = this.spawnCollision(false, (class_1297)this.getPrimary(), this.getSecondary(), 0.5);
        if (centerCollider != null) {
            this.collisionStorage.add(centerCollider.method_5628());
        }
    }

    private void sendAttachChainPacket(class_1937 world) {
        assert (world instanceof class_3218);
        Set<class_3222> trackingPlayers = this.getTrackingPlayers(world);
        for (class_3222 player : trackingPlayers) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ChainAttachPayload(this, true));
        }
    }

    @Nullable
    private class_1297 spawnCollision(boolean reverse, class_1297 start, class_1297 end, double v) {
        class_243 endPos;
        assert (this.getPrimary().method_37908() instanceof class_3218);
        class_243 startPos = start.method_19538().method_1019(start.method_45321(0.0f));
        class_243 tmp = endPos = end.method_19538().method_1019(end.method_45321(0.0f));
        if (reverse) {
            endPos = startPos;
            startPos = tmp;
        }
        class_243 offset = Helper.getChainOffset(startPos, endPos);
        startPos = startPos.method_1031(offset.method_10216(), 0.0, offset.method_10215());
        endPos = endPos.method_1031(-offset.method_10216(), 0.0, -offset.method_10215());
        double distance = startPos.method_1022(endPos);
        double x = class_3532.method_16436((double)v, (double)startPos.method_10216(), (double)endPos.method_10216());
        double y = startPos.method_10214() + Helper.drip2(v * distance, distance, endPos.method_10214() - startPos.method_10214());
        double z = class_3532.method_16436((double)v, (double)startPos.method_10215(), (double)endPos.method_10215());
        ChainCollisionEntity c = new ChainCollisionEntity(this.getPrimary().method_37908(), x, y += (double)(-ModEntityTypes.CHAIN_COLLISION.method_17686() + 0.125f), z, this);
        if (this.getPrimary().method_37908().method_8649((class_1297)c)) {
            return c;
        }
        ConnectibleChains.LOGGER.warn("Tried to summon collision entity for a chain, failed to do so");
        return null;
    }

    private Set<class_3222> getTrackingPlayers(class_1937 world) {
        assert (world instanceof class_3218);
        HashSet<class_3222> trackingPlayers = new HashSet<class_3222>(PlayerLookup.around((class_3218)((class_3218)world), (class_2382)this.getPrimary().method_24515(), (double)2048.0));
        trackingPlayers.addAll(PlayerLookup.around((class_3218)((class_3218)world), (class_2382)this.getSecondary().method_24515(), (double)2048.0));
        return trackingPlayers;
    }

    public boolean isDead() {
        return !this.alive;
    }

    public double getSquaredDistance() {
        return this.getPrimary().method_5858(this.getSecondary());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainLink link = (ChainLink)o;
        boolean partnersEqual = this.getPrimary().equals(link.getPrimary()) && this.getSecondary().equals((Object)link.getSecondary()) || this.getPrimary().equals(link.getSecondary()) && this.getSecondary().equals((Object)link.getPrimary());
        return this.alive == link.alive && partnersEqual;
    }

    public int hashCode() {
        return Objects.hash(this.getPrimary(), this.getSecondary(), this.alive);
    }

    public boolean needsBeDestroyed() {
        return this.getPrimary().method_31481() || this.getSecondary().method_31481();
    }

    public void destroy(boolean mayDrop) {
        class_1657 player;
        if (!this.alive) {
            return;
        }
        boolean drop = mayDrop;
        class_1937 world = this.getPrimary().method_37908();
        this.alive = false;
        if (world.field_9236) {
            return;
        }
        class_1297 class_12972 = this.getSecondary();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_7337()) {
            drop = false;
        }
        if (!world.method_8450().method_8355(class_1928.field_19392)) {
            drop = false;
        }
        if (drop) {
            class_1799 stack = new class_1799((class_1935)this.getSourceItem());
            class_1297 class_12973 = this.getSecondary();
            if (class_12973 instanceof class_1657) {
                class_1657 player2 = (class_1657)class_12973;
                player2.method_7270(stack);
            } else {
                class_243 middle = Helper.middleOf(this.getPrimary().method_19538(), this.getSecondary().method_19538());
                class_1542 itemEntity = new class_1542(world, middle.field_1352, middle.field_1351, middle.field_1350, stack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        this.destroyCollision();
        if (!this.primary.method_31481() && !this.secondary.method_31481()) {
            this.sendDetachChainPacket(world);
        }
    }

    private void destroyCollision() {
        for (Integer entityId : this.collisionStorage) {
            class_1297 e = this.getPrimary().method_37908().method_8469(entityId.intValue());
            if (e instanceof ChainCollisionEntity) {
                e.method_5650(class_1297.class_5529.field_26999);
                continue;
            }
            ConnectibleChains.LOGGER.warn("Collision storage contained reference to {} (#{}) which is not a collision entity.", (Object)e, (Object)entityId);
        }
        this.collisionStorage.clear();
    }

    private void sendDetachChainPacket(class_1937 world) {
        assert (world instanceof class_3218);
        Set<class_3222> trackingPlayers = this.getTrackingPlayers(world);
        for (class_3222 player : trackingPlayers) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ChainAttachPayload(this, false));
        }
    }

    public static class_2498 getSoundGroup(@Nullable class_1792 sourceItem) {
        if (sourceItem instanceof class_1747) {
            class_1747 blockItem = (class_1747)sourceItem;
            return blockItem.method_7711().method_9564().method_26231();
        }
        if (sourceItem instanceof class_1804) {
            return new class_2498(1.0f, 1.0f, class_3417.field_15184, class_2498.field_11543.method_10594(), class_3417.field_15062, class_2498.field_11543.method_10596(), class_2498.field_11543.method_10593());
        }
        return class_2498.field_24119;
    }

    @NotNull
    public ChainKnotEntity getPrimary() {
        return this.primary;
    }

    @NotNull
    public class_1297 getSecondary() {
        return this.secondary;
    }

    @NotNull
    public class_1792 getSourceItem() {
        return this.sourceItem;
    }
}

