/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guicompass_common_neoforge.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.guicompass_common_neoforge.config.ConfigHandler;
import com.natamus.guicompass_common_neoforge.util.Util;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;

public class GUIEvent {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final List<String> direction = Arrays.asList("S", "SW", "W", "NW", "N", "NE", "E", "SE", "S");

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (GUIEvent.mc.gui.getDebugOverlay().showDebugScreen()) {
            return;
        }
        if (ConfigHandler.mustHaveCompassInInventory) {
            boolean found = Util.isCompass(GUIEvent.mc.player.getOffhandItem());
            if (!found) {
                Inventory inv = GUIEvent.mc.player.getInventory();
                for (int n = 0; n <= 35; ++n) {
                    if (!Util.isCompass(inv.getItem(n))) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return;
            }
        }
        String coordinates = GUIEvent.getCoordinates();
        Font fontRenderer = GUIEvent.mc.font;
        Window scaled = mc.getWindow();
        int width = scaled.getGuiScaledWidth();
        int stringWidth = fontRenderer.width(coordinates);
        Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        int xcoord = ConfigHandler.compassPositionIsLeft ? 5 : (ConfigHandler.compassPositionIsCenter ? width / 2 - stringWidth / 2 : width - stringWidth - 5);
        GUIEvent.drawText(fontRenderer, guiGraphics, coordinates, xcoord, ConfigHandler.compassHeightOffset, colour.getRGB(), ConfigHandler.drawTextShadow);
        poseStack.popPose();
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.drawString(font, (Component)Component.literal((String)content), x, y, rgb, drawShadow);
    }

    private static String getCoordinates() {
        Entity player = mc.getCameraEntity();
        BlockPos ppos = player.blockPosition();
        String format = ConfigHandler.guiCompassFormat;
        Object toshow = "";
        if (format.contains("F")) {
            float degrees = Mth.wrapDegrees((float)player.getYRot());
            if (degrees < 0.0f) {
                degrees += 360.0f;
            }
            int facing = Math.round(degrees / 45.0f);
            toshow = (String)toshow + direction.get(facing) + ": ";
        }
        if (format.contains("X")) {
            toshow = (String)toshow + ppos.getX() + ", ";
        }
        if (format.contains("Y")) {
            toshow = (String)toshow + ppos.getY() + ", ";
        }
        if (format.contains("Z")) {
            toshow = (String)toshow + ppos.getZ() + ", ";
        }
        if (((String)toshow).length() < 2) {
            return "";
        }
        return ((String)toshow).substring(0, ((String)toshow).length() - 2);
    }
}

