/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blockentities.TallNetheriteDoorBlockEntity;
import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class TallNetheriteDoorBlock
extends TallDoorBlock
implements EntityBlock {
    public TallNetheriteDoorBlock(BlockSetType blockset, Block from) {
        super(blockset, from);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue((Property)THIRD) == TripleBlockPart.LOWER) {
            return new TallNetheriteDoorBlockEntity(pos, state);
        }
        return null;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        TallNetheriteDoorBlockEntity door;
        BlockPos delegatedPos = state.getValue((Property)THIRD) == TripleBlockPart.LOWER ? pos : (state.getValue((Property)THIRD) == TripleBlockPart.UPPER ? pos.below(2) : pos.below(1));
        BlockEntity be = level.getBlockEntity(delegatedPos);
        if (be != null && be instanceof TallNetheriteDoorBlockEntity && (door = (TallNetheriteDoorBlockEntity)be).handleAction(player, player.getUsedItemHand(), "door")) {
            TallNetheriteDoorBlock.tryOpenDoubleDoor(level, state, pos);
            BlockState newState = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(pos, newState, 10);
            this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
            level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

