/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.neoforge.state.properties.Orientation;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallFullFleshDoorBlock
extends TallDoorBlock {
    public static final EnumProperty<Orientation> ORIENTATION = DDBlockStateProperties.ORIENTATION;
    public static final int USE_UPDATE_FLAG = 10;
    protected static final int THICKNESS = 2;
    protected static final int CLOSED_SHAPE_INDEX = 0;
    protected static final int OPEN_SHAPE_INDEX = 1;
    protected static final VoxelShape[] x_NEG_AABB = TallFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 2.0, 16.0, 16.0);
    protected static final VoxelShape[] x_NONE_AABB = TallFullFleshDoorBlock.createClosedAndOpenShape(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    protected static final VoxelShape[] X_POS_AABB = TallFullFleshDoorBlock.createClosedAndOpenShape(14.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] Z_NEG_AABB = TallFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    protected static final VoxelShape[] Z_NONE_AABB = TallFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 7.0, 16.0, 16.0, 9.0);
    protected static final VoxelShape[] Z_POS_AABB = TallFullFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);

    public TallFullFleshDoorBlock(BlockSetType blockset, Block from) {
        super(blockset, from);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)((Object)Orientation.X_MIDDLE)));
    }

    private static VoxelShape[] createClosedAndOpenShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        VoxelShape closedShape = Block.box((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
        boolean caseX = x0 == 0.0 && x1 == 16.0;
        boolean caseZ = z0 == 0.0 && z1 == 16.0;
        double offset = 2.0;
        double xAL = caseX ? x0 + offset : x0;
        double zAL = caseZ ? z0 + offset : z0;
        double xBL = caseX ? x1 : x1;
        double zBL = caseZ ? z1 : z1;
        double xAR = caseX ? x0 : x0;
        double zAR = caseZ ? z0 : z0;
        double xBR = caseX ? x1 - offset : x1;
        double zBR = caseZ ? z1 - offset : z1;
        VoxelShape openShapeBottomLeft = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAL, (double)(y0 + offset), (double)zAL, (double)xBL, (double)y1, (double)zBL), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeBottomRight = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAR, (double)(y0 + offset), (double)zAR, (double)xBR, (double)y1, (double)zBR), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeMiddleLeft = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAL, (double)y0, (double)zAL, (double)xBL, (double)y1, (double)zBL), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeMiddleRight = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAR, (double)y0, (double)zAR, (double)xBR, (double)y1, (double)zBR), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeTopLeft = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAL, (double)y0, (double)zAL, (double)xBL, (double)(y1 - offset), (double)zBL), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeTopRight = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAR, (double)y0, (double)zAR, (double)xBR, (double)(y1 - offset), (double)zBR), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeForCollisionLeft = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAL, (double)y0, (double)zAL, (double)xBL, (double)y1, (double)zBL), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeForCollisionRight = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xAR, (double)y0, (double)zAR, (double)xBR, (double)y1, (double)zBR), (BooleanOp)BooleanOp.NOT_SAME);
        return new VoxelShape[]{closedShape, openShapeBottomLeft, openShapeMiddleLeft, openShapeTopLeft, openShapeBottomRight, openShapeMiddleRight, openShapeTopRight, openShapeForCollisionLeft, openShapeForCollisionRight};
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ORIENTATION});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterfilled;
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() >= level.getMaxBuildHeight() - 2 || !level.getBlockState(pos.above()).canBeReplaced(context) && !level.getBlockState(pos.above(2)).canBeReplaced(context)) {
            return null;
        }
        BlockState state = this.defaultBlockState();
        boolean bl = waterfilled = level.getFluidState(pos).getType() == Fluids.WATER;
        if (!context.replacingClickedOnBlock()) {
            Orientation orientation = Orientation.getXZOrientationFrom(context);
            state = (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)orientation));
        } else {
            boolean isXAxis = context.getHorizontalDirection().getAxis() == Direction.Axis.X;
            state = (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)(isXAxis ? Orientation.X_MIDDLE : Orientation.Z_MIDDLE)));
        }
        if (waterfilled) {
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        if (level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above())) {
            state = (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (context.getHorizontalDirection().getAxis() == Direction.Axis.X) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.EAST);
        } else if (context.getHorizontalDirection().getAxis() == Direction.Axis.Z) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        state = (BlockState)state.setValue((Property)HINGE, (Comparable)this.getHinge(context));
        if (context.getHorizontalDirection() == Direction.WEST || context.getHorizontalDirection() == Direction.SOUTH) {
            state = (BlockState)state.cycle((Property)HINGE);
        }
        return (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER));
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    private DoorHingeSide getHinge(BlockPlaceContext pContext) {
        boolean flag1;
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        Direction direction = pContext.getHorizontalDirection();
        BlockPos blockpos1 = blockpos.above();
        Direction direction1 = direction.getCounterClockWise();
        BlockPos blockpos2 = blockpos.relative(direction1);
        BlockState blockstate = blockgetter.getBlockState(blockpos2);
        BlockPos blockpos3 = blockpos1.relative(direction1);
        BlockState blockstate1 = blockgetter.getBlockState(blockpos3);
        Direction direction2 = direction.getClockWise();
        BlockPos blockpos4 = blockpos.relative(direction2);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos4);
        BlockPos blockpos5 = blockpos1.relative(direction2);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos5);
        int i = (blockstate.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.isCollisionShapeFullBlock((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        boolean flag = blockstate.is((Block)this) && blockstate.getValue((Property)THIRD) == TripleBlockPart.LOWER;
        boolean bl = flag1 = blockstate2.is((Block)this) && blockstate2.getValue((Property)THIRD) == TripleBlockPart.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.getStepX();
                int k = direction.getStepZ();
                Vec3 vec3 = pContext.getClickLocation();
                double d0 = vec3.x - (double)blockpos.getX();
                double d1 = vec3.z - (double)blockpos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockState newState = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, newState, 10);
        this.triggerOpenCloseEvent((Entity)player, level, pos, this.isOpen(newState));
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public void setOpen(@Nullable Entity user, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            BlockState newState = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
            level.setBlock(pos, newState, 10);
            this.triggerOpenCloseEvent(user, level, pos, open);
        }
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return state.getValue((Property)THIRD) == TripleBlockPart.LOWER || level.getBlockState(pos.below()).is((Block)this);
    }

    @Override
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean hasSignal;
        boolean bl = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.relative(this.isLowerHalf(state) ? Direction.UP : Direction.DOWN)) ? true : (hasSignal = false);
        if (!this.defaultBlockState().is(block) && hasSignal != this.isPowered(state)) {
            if (this.isOpen(state) != hasSignal) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasSignal));
                this.triggerOpenCloseEvent(null, level, pos, hasSignal);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasSignal)), 2);
        }
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        TripleBlockPart half = (TripleBlockPart)((Object)state.getValue((Property)THIRD));
        if (direction.getAxis() == Direction.Axis.Y && half == TripleBlockPart.LOWER == (direction == Direction.UP)) {
            if (neighborState.is((Block)this) && neighborState.getValue((Property)THIRD) != half) {
                return (BlockState)((BlockState)((BlockState)state.setValue(ORIENTATION, (Comparable)((Object)((Orientation)((Object)neighborState.getValue(ORIENTATION)))))).setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN)))).setValue((Property)POWERED, (Comparable)((Boolean)neighborState.getValue((Property)POWERED)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (half == TripleBlockPart.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void triggerOpenCloseEvent(@Nullable Entity entity, Level level, BlockPos pos, boolean isDoorOpening) {
        super.playSound(entity, level, pos, isDoorOpening);
        level.gameEvent(entity, (Holder)(isDoorOpening ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    public boolean isLowerHalf(BlockState state) {
        return state.getValue((Property)THIRD) == TripleBlockPart.LOWER;
    }

    public boolean isPowered(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx;
        int offset = state.getValue((Property)THIRD) == TripleBlockPart.LOWER ? 0 : (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE ? 1 : 2);
        int n = idx = this.isOpen(state) ? 1 + offset : 0;
        if (this.isOpen(state)) {
            idx += state.getValue((Property)HINGE) == DoorHingeSide.LEFT ? 0 : 3;
        }
        return switch ((Orientation)((Object)state.getValue(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> x_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> x_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.block();
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx;
        int n = idx = this.isOpen(state) ? 7 : 0;
        if (this.isOpen(state)) {
            idx += state.getValue((Property)HINGE) == DoorHingeSide.LEFT ? 0 : 1;
        }
        return switch ((Orientation)((Object)state.getValue(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> x_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> x_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.block();
        };
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> this.isOpen(state);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotationDirection) {
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        return (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        return (BlockState)((BlockState)state.setValue(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)))).cycle((Property)HINGE);
    }
}

