/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.neoforge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.neoforge.state.properties.Orientation;
import com.fizzware.dramaticdoors.neoforge.state.properties.TripleBlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallFleshDoorBlock
extends TallDoorBlock {
    public static final EnumProperty<Orientation> ORIENTATION = DDBlockStateProperties.ORIENTATION;
    public static final int USE_UPDATE_FLAG = 10;
    protected static final int THICKNESS = 2;
    protected static final int CLOSED_SHAPE_INDEX = 0;
    protected static final int OPEN_SHAPE_INDEX = 1;
    protected static final VoxelShape[] X_NEG_AABB = TallFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 2.0, 16.0, 16.0);
    protected static final VoxelShape[] X_NONE_AABB = TallFleshDoorBlock.createClosedAndOpenShape(7.0, 0.0, 0.0, 9.0, 16.0, 16.0);
    protected static final VoxelShape[] X_POS_AABB = TallFleshDoorBlock.createClosedAndOpenShape(14.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] Z_NEG_AABB = TallFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0);
    protected static final VoxelShape[] Z_NONE_AABB = TallFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 7.0, 16.0, 16.0, 9.0);
    protected static final VoxelShape[] Z_POS_AABB = TallFleshDoorBlock.createClosedAndOpenShape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0);

    public TallFleshDoorBlock(BlockSetType blockset, Block from) {
        super(blockset, from);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)((Object)Orientation.X_MIDDLE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ORIENTATION});
    }

    private static VoxelShape[] createClosedAndOpenShape(double x0, double y0, double z0, double x1, double y1, double z1) {
        VoxelShape closedShape = Block.box((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1);
        boolean caseX = x0 == 0.0 && x1 == 16.0;
        boolean caseZ = z0 == 0.0 && z1 == 16.0;
        double offset = 2.0;
        double xA = caseX ? x0 + offset : x0;
        double zA = caseZ ? z0 + offset : z0;
        double xB = caseX ? x1 - offset : x1;
        double zB = caseZ ? z1 - offset : z1;
        VoxelShape openShapeBottom = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xA, (double)(y0 + offset), (double)zA, (double)xB, (double)y1, (double)zB), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeMiddle = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xA, (double)y0, (double)zA, (double)xB, (double)y1, (double)zB), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeTop = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xA, (double)y0, (double)zA, (double)xB, (double)(y1 - offset), (double)zB), (BooleanOp)BooleanOp.NOT_SAME);
        VoxelShape openShapeForCollision = Shapes.join((VoxelShape)closedShape, (VoxelShape)Block.box((double)xA, (double)y0, (double)zA, (double)xB, (double)y1, (double)zB), (BooleanOp)BooleanOp.NOT_SAME);
        return new VoxelShape[]{closedShape, openShapeBottom, openShapeMiddle, openShapeTop, openShapeForCollision};
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (pos.getY() >= level.getMaxBuildHeight() - 2 || !level.getBlockState(pos.above()).canBeReplaced(context) && !level.getBlockState(pos.above(2)).canBeReplaced(context)) {
            return null;
        }
        BlockState state = this.defaultBlockState();
        if (!context.replacingClickedOnBlock()) {
            Orientation orientation = Orientation.getXZOrientationFrom(context);
            state = (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)orientation));
        } else {
            boolean isXAxis = context.getHorizontalDirection().getAxis() == Direction.Axis.X;
            state = (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)(isXAxis ? Orientation.X_MIDDLE : Orientation.Z_MIDDLE)));
        }
        if (level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above())) {
            state = (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)THIRD, (Comparable)((Object)TripleBlockPart.LOWER));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int offset = state.getValue((Property)THIRD) == TripleBlockPart.LOWER ? 0 : (state.getValue((Property)THIRD) == TripleBlockPart.MIDDLE ? 1 : 2);
        int idx = this.isOpen(state) ? 1 + offset : 0;
        return switch ((Orientation)((Object)state.getValue(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> X_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> X_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.block();
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx = this.isOpen(state) ? 4 : 0;
        return switch ((Orientation)((Object)state.getValue(ORIENTATION))) {
            case Orientation.X_POSITIVE -> X_POS_AABB[idx];
            case Orientation.X_MIDDLE -> X_NONE_AABB[idx];
            case Orientation.X_NEGATIVE -> X_NEG_AABB[idx];
            case Orientation.Z_POSITIVE -> Z_POS_AABB[idx];
            case Orientation.Z_MIDDLE -> Z_NONE_AABB[idx];
            case Orientation.Z_NEGATIVE -> Z_NEG_AABB[idx];
            default -> Shapes.block();
        };
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> this.isOpen(state);
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotationDirection) {
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        return (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)orientation.rotate(rotationDirection)));
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirror) {
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        return (BlockState)state.setValue(ORIENTATION, (Comparable)((Object)orientation.mirror(mirror)));
    }
}

