/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blockentities.TallNetheriteDoorBlockEntity;
import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class ShortNetheriteDoorBlock
extends ShortDoorBlock
implements EntityBlock {
    public ShortNetheriteDoorBlock(BlockSetType blockset, Block from) {
        super(blockset, from);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TallNetheriteDoorBlockEntity(pos, state);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        TallNetheriteDoorBlockEntity door;
        BlockEntity be = level.getBlockEntity(pos);
        if (be != null && be instanceof TallNetheriteDoorBlockEntity && (door = (TallNetheriteDoorBlockEntity)be).handleAction(player, player.getUsedItemHand(), "door")) {
            ShortNetheriteDoorBlock.tryOpenDoubleDoor(level, state, pos);
            BlockState newState = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(pos, newState, 10);
            this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
            level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

