/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.blocks;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortWeatheringDoorBlock;
import com.fizzware.dramaticdoors.neoforge.compat.Compats;
import com.fizzware.dramaticdoors.neoforge.compat.registries.SupplementariesCompat;
import com.fizzware.dramaticdoors.neoforge.tags.DDBlockTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShortDoorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<ShortDoorBlock> CODEC = RecordCodecBuilder.mapCodec(p_308821_ -> p_308821_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(ShortDoorBlock::type), (App)ShortDoorBlock.propertiesCodec()).apply((Applicative)p_308821_, ShortDoorBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final BlockSetType type;
    public static final ResourceLocation TOOTH_DOOR_RES = ResourceLocation.fromNamespaceAndPath((String)"dramaticdoors", (String)"short_tooth_door");

    public ShortDoorBlock(BlockSetType blockset, Block from) {
        this(blockset, from, null);
    }

    public ShortDoorBlock(BlockSetType blockset, Block from, @Nullable FeatureFlag flag) {
        super(flag != null ? BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)from).requiredFeatures(new FeatureFlag[]{flag}) : BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)from));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.type = blockset;
    }

    public ShortDoorBlock(BlockSetType blockset, BlockBehaviour.Properties properties) {
        super(properties.sound(blockset.soundType()));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.FALSE)).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.type = blockset;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !this.canSurvive(stateIn, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        if (blockpos.getY() < context.getLevel().getMaxBuildHeight() && context.getLevel().getBlockState(blockpos).canBeReplaced(context)) {
            boolean waterfilled;
            Level level = context.getLevel();
            Direction face = context.getHorizontalDirection();
            DoorHingeSide hinge = this.getHinge(context);
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.above());
            boolean bl = waterfilled = level.getFluidState(blockpos).getType() == Fluids.WATER;
            if (context.getClickedFace() == context.getHorizontalDirection().getOpposite() && context.getClickedFace().getAxis().isHorizontal()) {
                face = face.getOpposite();
                hinge = hinge == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            }
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)face)).setValue(HINGE, (Comparable)hinge)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterfilled));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    protected DoorHingeSide getHinge(BlockPlaceContext context) {
        boolean rightIsLowerOfSameType;
        Level BlockGetter2 = context.getLevel();
        BlockPos placePos = context.getClickedPos();
        Direction behindDir = context.getHorizontalDirection();
        Direction leftDir = behindDir.getCounterClockWise();
        BlockPos leftPos = placePos.relative(leftDir);
        BlockState leftBlockstate = BlockGetter2.getBlockState(leftPos);
        Direction rightDir = behindDir.getClockWise();
        BlockPos rightPos = placePos.relative(rightDir);
        BlockState rightBlockstate = BlockGetter2.getBlockState(rightPos);
        int i = (leftBlockstate.isCollisionShapeFullBlock((BlockGetter)BlockGetter2, leftPos) ? -1 : 0) + (rightBlockstate.isCollisionShapeFullBlock((BlockGetter)BlockGetter2, rightPos) ? 1 : 0);
        boolean leftIsLowerOfSameType = leftBlockstate.getBlock() == this;
        boolean bl = rightIsLowerOfSameType = rightBlockstate.getBlock() == this;
        if ((!leftIsLowerOfSameType || rightIsLowerOfSameType) && i <= 0) {
            if ((!rightIsLowerOfSameType || leftIsLowerOfSameType) && i >= 0) {
                int j = behindDir.getStepX();
                int k = behindDir.getStepZ();
                Vec3 vec3d = context.getClickLocation();
                double d0 = vec3d.x - (double)placePos.getX();
                double d1 = vec3d.z - (double)placePos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack itemstack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.type() == BlockSetType.COPPER && itemstack.getItem() instanceof AxeItem && player.isCrouching() && ShortWeatheringDoorBlock.getUnwaxed(state).isPresent()) {
            BlockState newstate = ShortWeatheringDoorBlock.getUnwaxed(state).get();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, itemstack);
            }
            level.setBlock(pos, newstate, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newstate));
            level.levelEvent(player, 3003, pos, 0);
            itemstack.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!this.type.canOpenByHand() && !state.is(DDBlockTags.MOB_INTERACTABLE_SHORT_DOORS)) {
            return InteractionResult.PASS;
        }
        if (Compats.SUPPLEMENTARIES_INSTALLED && this == SupplementariesCompat.SHORT_GOLD_DOOR && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 10);
        this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
        level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (Compats.BLUEPRINT_INSTALLED && this == BuiltInRegistries.BLOCK.get(TOOTH_DOOR_RES)) {
            level.scheduleTick(pos, (Block)this, 20);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!Compats.BLUEPRINT_INSTALLED) {
            return;
        }
        if (this != BuiltInRegistries.BLOCK.get(TOOTH_DOOR_RES)) {
            return;
        }
        if (!level.isClientSide) {
            state = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(pos, state, 10);
            this.playSound(null, (Level)level, pos, (Boolean)state.getValue((Property)OPEN));
        }
    }

    public void toggleDoor(Level level, BlockPos pos, boolean open) {
        BlockState blockstate = level.getBlockState(pos);
        if (blockstate.getBlock() == this && (Boolean)blockstate.getValue((Property)OPEN) != open) {
            level.setBlock(pos, (BlockState)blockstate.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(null, level, pos, open);
        }
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != open) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(entity, level, pos, open);
            level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
            BlockState stateAbove = level.getBlockState(pos.above(1));
            if (stateAbove.is(DDBlockTags.SHORT_WOODEN_DOORS) && (level.isNight() && (open || ((Boolean)stateAbove.getValue((Property)OPEN)).booleanValue()) || level.isDay() && !((Boolean)stateAbove.getValue((Property)OPEN)).booleanValue())) {
                level.setBlock(pos.above(), (BlockState)stateAbove.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.hasNeighborSignal(pos);
        if (blockIn != this && flag != (Boolean)state.getValue((Property)POWERED)) {
            if (Compats.SUPPLEMENTARIES_INSTALLED && this == SupplementariesCompat.SHORT_GOLD_DOOR) {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            } else {
                if (flag != (Boolean)state.getValue((Property)OPEN)) {
                    this.playSound(null, level, pos, flag);
                }
                ShortDoorBlock.tryOpenDoubleDoor(level, state, pos);
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                    level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
                }
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    protected void playSound(@Nullable Entity entity, Level level, BlockPos pos, boolean isOpen) {
        level.playSound(entity, pos, isOpen ? this.type.doorOpen() : this.type.doorClose(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HINGE, POWERED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        boolean flag = (Boolean)state.getValue((Property)OPEN) == false;
        boolean flag1 = state.getValue(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean allowsMovement(BlockState state, BlockGetter level, BlockPos pos, PathType type) {
        switch (type) {
            case WALKABLE: {
                return (Boolean)state.getValue((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case OPEN: {
                return (Boolean)state.getValue((Property)OPEN);
            }
        }
        return false;
    }

    public PushReaction getPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING))).cycle(HINGE);
    }

    public static boolean isWoodenDoor(Level level, BlockPos pos) {
        return ShortDoorBlock.isWoodenDoor(level.getBlockState(pos));
    }

    public static boolean isWoodenDoor(BlockState state) {
        return state.getBlock() instanceof ShortDoorBlock && state.is(DDBlockTags.SHORT_WOODEN_DOORS);
    }

    public static void tryOpenDoubleDoor(Level world, BlockState state, BlockPos pos) {
        if (Compats.DOUBLE_DOORS_INSTALLED || Compats.COUPLINGS_INSTALLED) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            boolean isOpen = (Boolean)state.getValue((Property)OPEN);
            DoorHingeSide isMirrored = (DoorHingeSide)state.getValue(HINGE);
            BlockPos mirrorPos = pos.relative(isMirrored == DoorHingeSide.RIGHT ? direction.getCounterClockWise() : direction.getClockWise());
            BlockPos doorPos = mirrorPos;
            BlockState other = world.getBlockState(doorPos);
            if (other.getBlock() == state.getBlock() && other.getValue((Property)FACING) == direction && !((Boolean)other.getValue((Property)POWERED)).booleanValue() && (Boolean)other.getValue((Property)OPEN) == isOpen && other.getValue(HINGE) != isMirrored) {
                BlockState newState = (BlockState)other.cycle((Property)OPEN);
                world.setBlock(doorPos, newState, 10);
            }
        }
    }

    public BlockSetType type() {
        return this.type;
    }
}

