/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.fabric.registry;

import com.fizzware.dramaticdoors.fabric.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.ShortWeatheringDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallSlidingDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallStableDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallWeatheringDoorBlock;
import com.fizzware.dramaticdoors.fabric.compat.Compats;
import com.fizzware.dramaticdoors.fabric.items.ShortDoorItem;
import com.fizzware.dramaticdoors.fabric.items.TallDoorItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5955;
import net.minecraft.class_7923;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class DDRegistry {
    public static final List<Pair<String, class_2248>> DOOR_BLOCKS_TO_REGISTER = new ArrayList<Pair<String, class_2248>>();
    public static final List<Pair<String, class_1792>> DOOR_ITEMS_TO_REGISTER = new ArrayList<Pair<String, class_1792>>();
    public static final class_1792.class_1793 PROPERTIES = new class_1792.class_1793();

    public static void registerVanilla() {
        DDRegistry.registerDoorBlockAndItem("tall_oak_door", "short_oak_door", class_2246.field_10149, class_8177.field_42823, true);
        DDRegistry.registerDoorBlockAndItem("tall_spruce_door", "short_spruce_door", class_2246.field_10521, class_8177.field_42824, true);
        DDRegistry.registerDoorBlockAndItem("tall_birch_door", "short_birch_door", class_2246.field_10352, class_8177.field_42825, true);
        DDRegistry.registerDoorBlockAndItem("tall_jungle_door", "short_jungle_door", class_2246.field_10627, class_8177.field_42828, true);
        DDRegistry.registerDoorBlockAndItem("tall_acacia_door", "short_acacia_door", class_2246.field_10232, class_8177.field_42826, true);
        DDRegistry.registerDoorBlockAndItem("tall_dark_oak_door", "short_dark_oak_door", class_2246.field_10403, class_8177.field_42829, true);
        DDRegistry.registerDoorBlockAndItem("tall_mangrove_door", "short_mangrove_door", class_2246.field_37566, class_8177.field_42832, true);
        DDRegistry.registerDoorBlockAndItem("tall_cherry_door", "short_cherry_door", class_2246.field_42748, class_8177.field_42827, true);
        DDRegistry.registerDoorBlockAndItem("tall_bamboo_door", "short_bamboo_door", class_2246.field_40291, class_8177.field_42833, true);
        DDRegistry.registerDoorBlockAndItem("tall_crimson_door", "short_crimson_door", class_2246.field_22102, class_8177.field_42830, true);
        DDRegistry.registerDoorBlockAndItem("tall_warped_door", "short_warped_door", class_2246.field_22103, class_8177.field_42831, true);
        if (Compats.modChecker.isModLoaded("immersive_weathering")) {
            DDRegistry.registerWeatheringDoorBlockAndItem("tall_iron_door", "short_iron_door", class_2246.field_9973.method_54095(), class_8177.field_42819, true, class_5955.class_5811.field_28704);
        } else {
            DDRegistry.registerDoorBlockAndItem("tall_iron_door", "short_iron_door", class_2246.field_9973, class_8177.field_42819, true);
        }
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_copper_door", "short_copper_door", class_2246.field_47040.method_54095(), class_8177.field_47100, true, class_5955.class_5811.field_28704);
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_exposed_copper_door", "short_exposed_copper_door", class_2246.field_47041.method_54095(), class_8177.field_47100, true, class_5955.class_5811.field_28705);
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_weathered_copper_door", "short_weathered_copper_door", class_2246.field_47043.method_54095(), class_8177.field_47100, true, class_5955.class_5811.field_28706);
        DDRegistry.registerWeatheringDoorBlockAndItem("tall_oxidized_copper_door", "short_oxidized_copper_door", class_2246.field_47042.method_54095(), class_8177.field_47100, true, class_5955.class_5811.field_28707);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_copper_door", "short_waxed_copper_door", class_2246.field_47044.method_54095(), class_8177.field_47100, true);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_exposed_copper_door", "short_waxed_exposed_copper_door", class_2246.field_47045.method_54095(), class_8177.field_47100, true);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_weathered_copper_door", "short_waxed_weathered_copper_door", class_2246.field_47047.method_54095(), class_8177.field_47100, true);
        DDRegistry.registerDoorBlockAndItem("tall_waxed_oxidized_copper_door", "short_waxed_oxidized_copper_door", class_2246.field_47046.method_54095(), class_8177.field_47100, true);
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, class_8177 blocksettype, boolean includeShort) {
        class_1792 tempItem;
        class_2248 tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createDoorBlock(block, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, class_4970.class_2251 properties, class_8177 blocksettype, boolean includeShort) {
        class_1792 tempItem;
        class_2248 tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(properties, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createDoorBlock(properties, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerWeatheringDoorBlockAndItem(String tallname, @Nullable String shortname, class_4970.class_2251 properties, class_8177 blocksettype, boolean includeShort, class_5955.class_5811 state) {
        class_1792 tempItem;
        class_2248 tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createCopperDoorBlock(properties, blocksettype, false, state);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createCopperDoorBlock(properties, blocksettype, true, state);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, class_8177 blocksettype, boolean includeShort) {
        class_1792 tempItem;
        class_2248 tempBlock;
        if (includeShort) {
            tempBlock = DDRegistry.createSlidingDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
        tempBlock = DDRegistry.createSlidingDoorBlock(block, blocksettype, true);
        tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
    }

    public static void registerStableDoorBlockAndItem(String tallname, @Nullable String shortname, class_2248 block, class_8177 blocksettype, boolean includeShort) {
        class_2248 tempBlock = DDRegistry.createStableDoorBlock(block, blocksettype, true);
        class_1792 tempItem = DDRegistry.createDoorItem(tempBlock, true);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createStableDoorBlock(block, blocksettype, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, class_2248>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, class_1792>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    protected static class_2248 createCopperDoorBlock(class_4970.class_2251 properties, class_8177 blocksettype, boolean isTall, class_5955.class_5811 state) {
        return isTall ? new TallWeatheringDoorBlock(blocksettype, state, properties) : new ShortWeatheringDoorBlock(blocksettype, state, properties);
    }

    protected static class_2248 createSlidingDoorBlock(class_2248 block, class_8177 blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw sliding doors are currently not supported.");
        }
        return new TallSlidingDoorBlock(blocksettype, block);
    }

    protected static class_2248 createStableDoorBlock(class_2248 block, class_8177 blocksettype, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw stable doors are currently not supported.");
        }
        return new TallStableDoorBlock(blocksettype, block);
    }

    protected static class_2248 createDoorBlock(class_2248 block, class_8177 blocksettype, boolean isTall) {
        return isTall ? new TallDoorBlock(blocksettype, block) : new ShortDoorBlock(blocksettype, block);
    }

    protected static class_2248 createDoorBlock(class_4970.class_2251 properties, class_8177 blocksettype, boolean isTall) {
        return isTall ? new TallDoorBlock(blocksettype, properties) : new ShortDoorBlock(blocksettype, properties);
    }

    protected static class_1792 createDoorItem(class_2248 block, boolean isTall) {
        return isTall ? new TallDoorItem(block, PROPERTIES) : new ShortDoorItem(block, PROPERTIES);
    }

    public static class_2248 getBlockByKey(class_2960 loc) {
        return DDRegistry.getBlockByKey(loc, class_2246.field_10149);
    }

    public static class_2248 getBlockByKey(class_2960 loc, class_2248 fallback) {
        if (class_7923.field_41175.method_10250(loc)) {
            return (class_2248)class_7923.field_41175.method_10223(loc);
        }
        return fallback;
    }

    public static class_2248 getBlockFromResourceLocation(class_2960 resource) {
        return DDRegistry.getBlockFromResourceLocation(resource, class_2246.field_10149);
    }

    public static class_2248 getBlockFromResourceLocation(class_2960 resource, class_2248 fallback) {
        return class_7923.field_41175.method_17966(resource).orElse(fallback);
    }
}

