/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.fabric.fabric.datagen;

import com.fizzware.dramaticdoors.fabric.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.fabric.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.fabric.items.ShortDoorItem;
import com.fizzware.dramaticdoors.fabric.items.TallDoorItem;
import com.fizzware.dramaticdoors.fabric.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.fabric.state.properties.TripleBlockPart;
import com.google.gson.JsonElement;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4917;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;

public class DDModelProvider
extends FabricModelProvider {
    private BiConsumer<class_2960, Supplier<JsonElement>> modelOutput;
    private Consumer<class_4917> blockStateOutput;
    public static final class_4945 MIDDLE = class_4945.method_27044((String)"middle", (class_4945)class_4945.field_23018);
    public static final class_4942 DOOR_SHORT_LEFT = DDModelProvider.create("door_short_left", "_left", class_4945.field_23011);
    public static final class_4942 DOOR_SHORT_LEFT_OPEN = DDModelProvider.create("door_short_left_open", "_left_open", class_4945.field_23011);
    public static final class_4942 DOOR_SHORT_RIGHT = DDModelProvider.create("door_short_right", "_right", class_4945.field_23011);
    public static final class_4942 DOOR_SHORT_RIGHT_OPEN = DDModelProvider.create("door_short_right_open", "_right_open", class_4945.field_23011);
    public static final class_4942 DOOR_MIDDLE_LEFT = DDModelProvider.create("door_middle_left", "_middle_left", class_4945.field_23014, MIDDLE, class_4945.field_23015);
    public static final class_4942 DOOR_MIDDLE_LEFT_OPEN = DDModelProvider.create("door_middle_left_open", "_middle_left_open", class_4945.field_23014, MIDDLE, class_4945.field_23015);
    public static final class_4942 DOOR_MIDDLE_RIGHT = DDModelProvider.create("door_middle_right", "_middle_right", class_4945.field_23014, MIDDLE, class_4945.field_23015);
    public static final class_4942 DOOR_MIDDLE_RIGHT_OPEN = DDModelProvider.create("door_middle_right_open", "_middle_right_open", class_4945.field_23014, MIDDLE, class_4945.field_23015);

    public DDModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        this.modelOutput = blockStateModelGenerator.field_22831;
        this.blockStateOutput = blockStateModelGenerator.field_22830;
        for (class_2248 block2 : class_7923.field_41175.method_10220().filter(block -> block instanceof ShortDoorBlock || block instanceof TallDoorBlock).toList()) {
            if (block2 instanceof ShortDoorBlock) {
                this.createShortDoor(block2);
            }
            if (!(block2 instanceof TallDoorBlock)) continue;
            this.createTallDoor(block2);
        }
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        for (class_1792 item2 : class_7923.field_41178.method_10220().filter(item -> item instanceof ShortDoorItem || item instanceof TallDoorItem).toList()) {
            itemModelGenerator.method_25733(item2, class_4943.field_22938);
        }
    }

    private static class_4942 create(String blockModelLocation, String suffix, class_4945 ... requiredSlots) {
        return new class_4942(Optional.of(class_2960.method_60655((String)"dramaticdoors", (String)("block/" + blockModelLocation))), Optional.of(suffix), requiredSlots);
    }

    public void createTallDoor(class_2248 doorBlock) {
        class_4944 textureMapping = DDModelProvider.tallDoor(doorBlock);
        class_2960 resourceLocation1 = class_4943.field_38016.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation2 = class_4943.field_38017.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation3 = class_4943.field_38018.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation4 = class_4943.field_38019.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation5 = DOOR_MIDDLE_LEFT.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation6 = DOOR_MIDDLE_LEFT_OPEN.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation7 = DOOR_MIDDLE_RIGHT.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation8 = DOOR_MIDDLE_RIGHT_OPEN.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation9 = class_4943.field_38020.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation10 = class_4943.field_38021.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation11 = class_4943.field_38022.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation12 = class_4943.field_38023.method_25846(doorBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(DDModelProvider.createTallDoor(doorBlock, resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8, resourceLocation9, resourceLocation10, resourceLocation11, resourceLocation12));
    }

    public void createShortDoor(class_2248 doorBlock) {
        class_4944 textureMapping = DDModelProvider.shortDoor(doorBlock);
        class_2960 resourceLocation = DOOR_SHORT_LEFT.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation2 = DOOR_SHORT_LEFT_OPEN.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation3 = DOOR_SHORT_RIGHT.method_25846(doorBlock, textureMapping, this.modelOutput);
        class_2960 resourceLocation4 = DOOR_SHORT_RIGHT_OPEN.method_25846(doorBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(DDModelProvider.createShortDoor(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
    }

    public static class_4944 tallDoor(class_2248 doorBlock) {
        return new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)doorBlock, (String)"_top")).method_25868(MIDDLE, class_4944.method_25866((class_2248)doorBlock, (String)"_middle")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)doorBlock, (String)"_bottom"));
    }

    public static class_4944 shortDoor(class_2248 doorBlock) {
        return new class_4944().method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)doorBlock, (String)""));
    }

    public static class_4917 createTallDoor(class_2248 doorBlock, class_2960 resourceLocation, class_2960 resourceLocation2, class_2960 resourceLocation3, class_2960 resourceLocation4, class_2960 resourceLocation5, class_2960 resourceLocation6, class_2960 resourceLocation7, class_2960 resourceLocation8, class_2960 resourceLocation9, class_2960 resourceLocation10, class_2960 resourceLocation11, class_2960 resourceLocation12) {
        return class_4925.method_25769((class_2248)doorBlock).method_25775(DDModelProvider.configureDoorThird(DDModelProvider.configureDoorThird(DDModelProvider.configureDoorThird((class_4926.class_4930<class_2350, TripleBlockPart, class_2750, Boolean>)class_4926.method_25786((class_2769)class_2741.field_12481, DDBlockStateProperties.TRIPLE_BLOCK_THIRD, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537), TripleBlockPart.LOWER, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4), TripleBlockPart.MIDDLE, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8), TripleBlockPart.UPPER, resourceLocation9, resourceLocation10, resourceLocation11, resourceLocation12));
    }

    public static class_4917 createShortDoor(class_2248 doorBlock, class_2960 resourceLocation, class_2960 resourceLocation2, class_2960 resourceLocation3, class_2960 resourceLocation4) {
        return class_4925.method_25769((class_2248)doorBlock).method_25775(DDModelProvider.configureDoorShort((class_4926.class_4929<class_2350, class_2750, Boolean>)class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537), TripleBlockPart.LOWER, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
    }

    public static class_4926.class_4930<class_2350, TripleBlockPart, class_2750, Boolean> configureDoorThird(class_4926.class_4930<class_2350, TripleBlockPart, class_2750, Boolean> c4, TripleBlockPart tripleBlockPart, class_2960 resourceLocation, class_2960 resourceLocation2, class_2960 resourceLocation3, class_2960 resourceLocation4) {
        return c4.method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)).method_25811((Comparable)class_2350.field_11034, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25811((Comparable)class_2350.field_11035, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4)).method_25811((Comparable)class_2350.field_11039, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25811((Comparable)class_2350.field_11043, (Comparable)((Object)tripleBlockPart), (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
    }

    public static class_4926.class_4929<class_2350, class_2750, Boolean> configureDoorShort(class_4926.class_4929<class_2350, class_2750, Boolean> c3, TripleBlockPart tripleBlockPart, class_2960 resourceLocation, class_2960 resourceLocation2, class_2960 resourceLocation3, class_2960 resourceLocation4) {
        return c3.method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12588, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2750.field_12586, (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
    }
}

