/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.placeholders.api.arguments.StringArgs;
import java.util.stream.Stream;

public class StringArgOps
implements DynamicOps<Either<String, StringArgs>> {
    public static final StringArgOps INSTANCE = new StringArgOps();

    public Either<String, StringArgs> empty() {
        return Either.right((Object)StringArgs.emptyNew());
    }

    public <U> U convertTo(DynamicOps<U> outOps, Either<String, StringArgs> input) {
        return (U)outOps.empty();
    }

    public DataResult<Number> getNumberValue(Either<String, StringArgs> input) {
        try {
            if (input.left().isPresent()) {
                return DataResult.success((Object)Double.valueOf((String)input.orThrow()));
            }
        }
        catch (Throwable ignored) {
            return DataResult.success((Object)(Boolean.parseBoolean((String)input.orThrow()) ? 1 : 0));
        }
        return DataResult.error(() -> String.valueOf(input) + " is not a number!");
    }

    public Either<String, StringArgs> createNumeric(Number i) {
        return Either.left((Object)i.toString());
    }

    public DataResult<String> getStringValue(Either<String, StringArgs> input) {
        return input.left().isPresent() ? DataResult.success((Object)((String)input.left().get())) : DataResult.error(() -> String.valueOf(input) + " is not a number!");
    }

    public Either<String, StringArgs> createString(String value) {
        return Either.left((Object)value);
    }

    public DataResult<Either<String, StringArgs>> mergeToList(Either<String, StringArgs> list, Either<String, StringArgs> value) {
        try {
            if (value.left().isPresent()) {
                ((StringArgs)list.right().get()).unsafeOrdered().add((String)value.left().orElseThrow());
            } else {
                ((StringArgs)list.right().get()).unsafeKeyedMap().put("" + ((StringArgs)list.right().get()).unsafeKeyedMap().size(), (StringArgs)value.right().orElseThrow());
            }
            return DataResult.success(list);
        }
        catch (Throwable e) {
            return DataResult.error(() -> String.valueOf(list) + " is not a list!");
        }
    }

    public DataResult<Either<String, StringArgs>> mergeToMap(Either<String, StringArgs> map, Either<String, StringArgs> key, Either<String, StringArgs> value) {
        try {
            if (value.left().isPresent()) {
                ((StringArgs)map.right().get()).unsafeKeyed().put((String)key.left().orElseThrow(), (String)value.left().orElseThrow());
            } else {
                ((StringArgs)map.right().get()).unsafeKeyedMap().put((String)key.left().orElseThrow(), (StringArgs)value.right().orElseThrow());
            }
            return DataResult.success(map);
        }
        catch (Throwable e) {
            return DataResult.error(() -> String.valueOf(key) + " is not a correct key!");
        }
    }

    public DataResult<Stream<Pair<Either<String, StringArgs>, Either<String, StringArgs>>>> getMapValues(Either<String, StringArgs> input) {
        try {
            return DataResult.success(Stream.concat(((StringArgs)input.right().get()).unsafeKeyed().entrySet().stream().map(e -> new Pair((Object)Either.left((Object)((String)e.getKey())), (Object)Either.left((Object)((String)e.getValue())))), ((StringArgs)input.right().get()).unsafeKeyedMap().entrySet().stream().map(e -> new Pair((Object)Either.left((Object)((String)e.getKey())), (Object)Either.right((Object)((StringArgs)e.getValue()))))));
        }
        catch (Throwable e2) {
            return DataResult.error(() -> String.valueOf(input) + " is not a map!");
        }
    }

    public Either<String, StringArgs> createMap(Stream<Pair<Either<String, StringArgs>, Either<String, StringArgs>>> map) {
        StringArgs arg = StringArgs.emptyNew();
        map.forEach(x -> ((Either)x.getSecond()).ifLeft(y -> arg.unsafeKeyed().put(((Either)x.getFirst()).left().orElse(""), (String)y)).ifRight(y -> arg.unsafeKeyedMap().put(((Either)x.getFirst()).left().orElse(""), (StringArgs)y)));
        return Either.right((Object)arg);
    }

    public DataResult<Stream<Either<String, StringArgs>>> getStream(Either<String, StringArgs> input) {
        return DataResult.success(input.left().isPresent() ? Stream.of(input) : Stream.concat(Stream.concat(((StringArgs)input.right().get()).unsafeKeyed().values().stream().map(Either::left), ((StringArgs)input.right().get()).unsafeOrdered().stream().map(Either::left)), ((StringArgs)input.right().get()).unsafeKeyedMap().values().stream().map(Either::right)));
    }

    public Either<String, StringArgs> createList(Stream<Either<String, StringArgs>> input) {
        StringArgs arg = StringArgs.emptyNew();
        input.forEach(x -> x.ifLeft(arg.unsafeOrdered()::add).ifRight(y -> arg.unsafeKeyedMap().put("" + arg.unsafeKeyedMap().size(), (StringArgs)y)));
        return Either.right((Object)arg);
    }

    public Either<String, StringArgs> remove(Either<String, StringArgs> input, String key) {
        input.ifRight(x -> {
            x.unsafeKeyed().remove(key);
            x.unsafeKeyedMap().remove(key);
        });
        return input;
    }
}

