/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.leaves_us_in_peace.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.sssubtlety.leaves_us_in_peace.FeatureControl;
import net.sssubtlety.leaves_us_in_peace.LeavesUsInPeace;
import net.sssubtlety.leaves_us_in_peace.mixin.accessor.DirectionAccessor;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_2397.class})
abstract class LeavesBlockMixin
extends class_2248 {
    @Unique
    @NotNull
    private static final ThreadLocal<Optional<class_2680>> currentLeaves = ThreadLocal.withInitial(Optional::empty);
    @Shadow
    @Final
    public static class_2758 field_11199;
    @Shadow
    @Final
    public static class_2746 field_11200;

    private LeavesBlockMixin(class_4970.class_2251 settings) {
        super(settings);
        throw new IllegalStateException("MixinLeavesBlock's dummy constructor called!");
    }

    @Inject(method={"getStateForNeighborUpdate"}, at={@At(value="HEAD")})
    private void captureNeighborBlock(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos, CallbackInfoReturnable<class_2680> cir) {
        if (FeatureControl.shouldMatchLeavesTypes()) {
            LeavesUsInPeace.updateLeavesTags(this);
        }
        currentLeaves.set(Optional.of(state));
    }

    @Inject(method={"getStateForNeighborUpdate"}, at={@At(value="TAIL")})
    private void resetCapturedNeighborBlock(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos, CallbackInfoReturnable<class_2680> cir) {
        currentLeaves.remove();
    }

    @Inject(method={"updateDistanceFromLogs"}, at={@At(value="HEAD")})
    private static void captureUpdatingBlock(class_2680 state, class_1936 world, class_2338 pos, CallbackInfoReturnable<class_2680> cir) {
        if (FeatureControl.shouldMatchLeavesTypes()) {
            LeavesUsInPeace.updateLeavesTags(state.method_26204());
        }
        currentLeaves.set(Optional.of(state));
    }

    @Inject(method={"updateDistanceFromLogs"}, at={@At(value="TAIL")})
    private static void resetCapturedUpdatingBlock(class_2680 state, class_1936 world, class_2338 pos, CallbackInfoReturnable<class_2680> cir) {
        currentLeaves.remove();
    }

    @ModifyArgs(method={"updateDistanceFromLogs"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/LeavesBlock;getDistanceFromLog(Lnet/minecraft/block/BlockState;)I"))
    private static void checkBlockState(Args args, class_2680 leavesState, class_1936 world, class_2338 pos) {
        if (FeatureControl.shouldMatchLogsToLeaves()) {
            LeavesUsInPeace.updateLogLeavesTags(((class_2680)args.get(0)).method_26204());
        }
    }

    @Redirect(method={"getOptionalDistanceFromLog"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/block/BlockState;isIn(Lnet/minecraft/registry/tag/TagKey;)Z"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/registry/tag/BlockTags;LOGS:Lnet/minecraft/registry/tag/TagKey;")))
    private static boolean tryMatchLog(class_2680 state, class_6862<class_2248> tagKey) {
        if (FeatureControl.shouldMatchLogsToLeaves()) {
            class_2248 block;
            class_6862<class_2248> logLeavesTag;
            if (state.method_26164(LeavesUsInPeace.LOGS_WITHOUT_LEAVES)) {
                return false;
            }
            if (currentLeaves.get().isPresent() && (logLeavesTag = LeavesUsInPeace.getLeavesForLog(block = state.method_26204())) != null && class_7923.field_41175.method_40266(logLeavesTag).isPresent()) {
                return currentLeaves.get().get().method_26164(logLeavesTag);
            }
        }
        return state.method_26164(class_3481.field_15475);
    }

    @ModifyExpressionValue(method={"getOptionalDistanceFromLog"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;contains(Lnet/minecraft/state/property/Property;)Z")})
    private static boolean matchLeaves(boolean original, class_2680 state) {
        Optional optOtherPersistent;
        if (!original) {
            return false;
        }
        if (currentLeaves.get().isEmpty()) {
            return true;
        }
        class_2680 currentLeavesState = currentLeaves.get().get();
        if (FeatureControl.shouldIgnorePersistentLeaves() && !((Boolean)currentLeavesState.method_11654((class_2769)field_11200)).booleanValue() && (optOtherPersistent = state.method_28500((class_2769)field_11200)).isPresent() && ((Boolean)optOtherPersistent.get()).booleanValue()) {
            return false;
        }
        if (state != null && FeatureControl.shouldMatchLeavesTypes()) {
            class_6862<class_2248> leavesTag = LeavesUsInPeace.getLeavesTag(currentLeavesState.method_26204());
            return FeatureControl.isMatchingLeaves(leavesTag, state, currentLeavesState);
        }
        return true;
    }

    @Inject(method={"scheduledTick"}, at={@At(value="TAIL")})
    private void postScheduledTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        if (!((Boolean)state.method_11654((class_2769)field_11200)).booleanValue() && FeatureControl.shouldAccelerateLeavesDecay()) {
            if ((Integer)state.method_11654((class_2769)field_11199) >= 7) {
                this.method_9514(state, world, pos, random);
                if (FeatureControl.shouldUpdateDiagonalLeaves()) {
                    class_6862<class_2248> leavesTag = LeavesUsInPeace.getLeavesTag(this);
                    LeavesBlockMixin.getDiagonalPositions(pos).forEach(blockPos -> LeavesBlockMixin.updateIfMatchingLeaves((class_1936)world, blockPos, leavesTag, random));
                }
            } else if ((Integer)world.method_8320(pos).method_11654((class_2769)field_11199) >= 7) {
                world.method_39279(pos, (class_2248)this, FeatureControl.getDecayDelay(random));
            }
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/world/ServerWorld;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z")})
    private void postRemoveBlock(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        if (FeatureControl.shouldDoDecayingLeavesEffects()) {
            this.method_33614((class_1937)world, null, pos, state);
        }
    }

    @Unique
    private static Collection<class_2338> getDiagonalPositions(class_2338 pos) {
        LinkedList<class_2338> diagonalPositions = new LinkedList<class_2338>();
        for (class_2350 direction : class_2350.values()) {
            if (direction.method_10161() >= 0) {
                diagonalPositions.add(pos.method_10093(direction).method_10093(direction.method_10170()));
                continue;
            }
            class_2338 vOffsetPos = pos.method_10093(direction);
            for (class_2350 horizontal : DirectionAccessor.leaves_us_in_peace$getHORIZONTAL()) {
                diagonalPositions.add(vOffsetPos.method_10093(direction).method_10093(horizontal.method_10170()));
            }
        }
        return diagonalPositions;
    }

    @Unique
    private static void updateIfMatchingLeaves(class_1936 world, class_2338 blockPos, class_6862<class_2248> leavesTag, class_5819 random) {
        class_2680 state = world.method_8320(blockPos);
        if (state != null && currentLeaves.get().isPresent() && FeatureControl.isMatchingLeaves(leavesTag, state, currentLeaves.get().get())) {
            world.method_39279(blockPos, state.method_26204(), FeatureControl.getDecayDelay(random));
        }
    }
}

