/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stackrefill_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class RefillEvent {
    private static final List<Pair<Player, ItemStack>> addstack = new ArrayList<Pair<Player, ItemStack>>();
    private static final List<Pair<InteractionHand, Pair<Player, ItemStack>>> addsingle = new ArrayList<Pair<InteractionHand, Pair<Player, ItemStack>>>();
    private static final List<Pair<Player, InteractionHand>> checkfishingrod = new ArrayList<Pair<Player, InteractionHand>>();
    private static final List<Pair<InteractionHand, Pair<Player, ItemStack>>> checkitemused = new ArrayList<Pair<InteractionHand, Pair<Player, ItemStack>>>();

    public static void onWorldTick(ServerLevel world) {
        RefillEvent.processTick(false);
    }

    public static void processTick(boolean isClientSide) {
        block23: {
            try {
                Player player;
                InteractionHand hand;
                Pair insidepair;
                Player player2;
                Pair<Player, ItemStack> pair;
                if (addstack.size() > 0) {
                    pair = addstack.getFirst();
                    if (pair != null) {
                        player2 = (Player)pair.getFirst();
                        ItemStack togive = (ItemStack)pair.getSecond();
                        ItemStack heldmainhand = player2.getMainHandItem();
                        if (heldmainhand.isEmpty()) {
                            player2.setItemInHand(InteractionHand.MAIN_HAND, togive);
                        } else {
                            ItemFunctions.giveOrDropItemStack((Player)player2, (ItemStack)togive);
                        }
                        player2.getInventory().setChanged();
                    }
                    addstack.removeFirst();
                }
                if (addsingle.size() > 0) {
                    pair = addsingle.getFirst();
                    if (pair != null) {
                        insidepair = (Pair)pair.getSecond();
                        hand = (InteractionHand)pair.getFirst();
                        player = (Player)insidepair.getFirst();
                        ItemStack handstack = player.getItemInHand(hand).copy();
                        player.setItemInHand(hand, (ItemStack)insidepair.getSecond());
                        if (!handstack.isEmpty()) {
                            ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)handstack);
                        }
                        player.getInventory().setChanged();
                    }
                    addsingle.removeFirst();
                }
                if (checkfishingrod.size() > 0) {
                    pair = checkfishingrod.getFirst();
                    if (pair != null) {
                        player2 = (Player)pair.getFirst();
                        if (player2.getItemInHand(hand = (InteractionHand)pair.getSecond()).isEmpty()) {
                            Inventory inv = player2.getInventory();
                            for (int i = 35; i > 8; --i) {
                                ItemStack slot = inv.getItem(i);
                                if (!(slot.getItem() instanceof FishingRodItem)) continue;
                                player2.setItemInHand(hand, slot.copy());
                                slot.setCount(0);
                                break;
                            }
                        }
                        player2.getInventory().setChanged();
                    }
                    checkfishingrod.removeFirst();
                }
                if (checkitemused.size() <= 0) break block23;
                pair = checkitemused.getFirst();
                if (pair != null) {
                    insidepair = (Pair)pair.getSecond();
                    hand = (InteractionHand)pair.getFirst();
                    player = (Player)insidepair.getFirst();
                    if (!player.isUsingItem()) {
                        ItemStack usedstack = (ItemStack)insidepair.getSecond();
                        ItemStack handstack = player.getItemInHand(hand).copy();
                        if (!usedstack.getItem().equals(handstack.getItem()) || usedstack.getCount() != handstack.getCount()) {
                            boolean shouldcontinue = false;
                            if (handstack.getCount() <= 1) {
                                if (usedstack.getItem().equals(handstack.getItem())) {
                                    if (handstack.isEmpty()) {
                                        shouldcontinue = true;
                                    }
                                } else {
                                    shouldcontinue = true;
                                }
                            }
                            if (shouldcontinue) {
                                Item useditem = usedstack.getItem();
                                Inventory inv = player.getInventory();
                                for (int i = 35; i > 8; --i) {
                                    ItemStack slot = inv.getItem(i);
                                    Item slotitem = slot.getItem();
                                    if (!useditem.equals(slotitem) || slotitem instanceof PotionItem && !Objects.equals(usedstack.get(DataComponents.POTION_CONTENTS), slot.get(DataComponents.POTION_CONTENTS))) continue;
                                    player.setItemInHand(hand, slot.copy());
                                    slot.setCount(0);
                                    if (!handstack.isEmpty()) {
                                        ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)handstack);
                                    }
                                    player.getInventory().setChanged();
                                    break;
                                }
                            }
                        }
                    }
                }
                checkitemused.removeFirst();
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    public static ItemStack onItemUse(Player player, ItemStack used, ItemStack newItem, InteractionHand hand) {
        if (player.isCreative()) {
            return null;
        }
        int amount = used.getCount();
        if (amount > 1) {
            return null;
        }
        Pair insidepair = new Pair((Object)player, (Object)used.copy());
        Pair pair = new Pair((Object)hand, (Object)insidepair);
        checkitemused.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        return null;
    }

    public static void onItemBreak(Player player, ItemStack used, InteractionHand hand) {
        if (player.isCreative()) {
            return;
        }
        if (used == null) {
            return;
        }
        Item useditem = used.getItem();
        if (useditem instanceof BlockItem || useditem instanceof BucketItem || useditem instanceof PotionItem) {
            return;
        }
        int amount = used.getCount();
        if (amount > 1) {
            return;
        }
        if (hand == null) {
            return;
        }
        Inventory inv = player.getInventory();
        for (int i = 35; i > 8; --i) {
            ItemStack slot = inv.getItem(i);
            Item slotitem = slot.getItem();
            if (!useditem.equals(slotitem)) continue;
            Pair insidepair = new Pair((Object)player, (Object)slot.copy());
            Pair pair = new Pair((Object)hand, (Object)insidepair);
            addsingle.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
            slot.setCount(0);
            break;
        }
        player.getInventory().setChanged();
    }

    public static void onItemToss(Player player, ItemStack tossedstack) {
        if (player.isCreative()) {
            return;
        }
        Item tosseditem = tossedstack.getItem();
        InteractionHand activehand = InteractionHand.MAIN_HAND;
        ItemStack activestack = player.getMainHandItem();
        if (!activestack.isEmpty()) {
            return;
        }
        if (tossedstack.getCount() > 1) {
            return;
        }
        Inventory inv = player.getInventory();
        for (int i = 35; i > 8; --i) {
            ItemStack slot = inv.getItem(i);
            Item slotitem = slot.getItem();
            if (!tosseditem.equals(slotitem) || slotitem instanceof PotionItem && !Objects.equals(tossedstack.get(DataComponents.POTION_CONTENTS), slot.get(DataComponents.POTION_CONTENTS))) continue;
            player.setItemInHand(activehand, slot.copy());
            slot.setCount(0);
            break;
        }
        player.getInventory().setChanged();
    }

    public static InteractionResultHolder<ItemStack> onItemRightClick(Player player, Level world, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCreative()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        Item item = stack.getItem();
        if (item instanceof FishingRodItem) {
            int damage = stack.getDamageValue();
            int maxdamage = stack.getMaxDamage();
            if (maxdamage - damage < 5) {
                Pair toadd = new Pair((Object)player, (Object)hand);
                checkfishingrod.add((Pair<Player, InteractionHand>)toadd);
            }
        } else if (item instanceof EggItem || item instanceof SnowballItem || item instanceof FireworkRocketItem) {
            if (stack.getCount() > 1) {
                return InteractionResultHolder.pass((Object)stack);
            }
            Pair insidepair = new Pair((Object)player, (Object)stack.copy());
            Pair pair = new Pair((Object)hand, (Object)insidepair);
            checkitemused.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static void onBlockRightClick(Level world, Player player, InteractionHand activehand, BlockPos pos, BlockHitResult hitVec) {
        if (player.isCreative()) {
            return;
        }
        if (player.isUsingItem()) {
            return;
        }
        ItemStack active = player.getItemInHand(activehand);
        int amount = active.getCount();
        if (amount > 26) {
            return;
        }
        Pair insidepair = new Pair((Object)player, (Object)active.copy());
        Pair pair = new Pair((Object)activehand, (Object)insidepair);
        try {
            checkitemused.add((Pair<InteractionHand, Pair<Player, ItemStack>>)pair);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

